--------------------------------------------------------------------------------
--  Copyright(C) 2007 by Xilinx, Inc. All rights reserved.
--  This text/file contains proprietary, confidential
--  information of Xilinx, Inc., is distributed under license
--  from Xilinx, Inc., and may be used, copied and/or
--  disclosed only pursuant to the terms of a valid license
--  agreement with Xilinx, Inc.  Xilinx hereby grants you
--  a license to use this text/file solely for design, simulation,
--  implementation and creation of design files limited
--  to Xilinx devices or technologies. Use with non-Xilinx
--  devices or technologies is expressly prohibited and
--  immediately terminates your license unless covered by
--  a separate agreement.
--
--  Xilinx is providing this design, code, or information
--  "as is" solely for use in developing programs and
--  solutions for Xilinx devices.  By providing this design,
--  code, or information as one possible implementation of
--  this feature, application or standard, Xilinx is making no
--  representation that this implementation is free from any
--  claims of infringement.  You are responsible for
--  obtaining any rights you may require for your implementation.
--  Xilinx expressly disclaims any warranty whatsoever with
--  respect to the adequacy of the implementation, including
--  but not limited to any warranties or representations that this
--  implementation is free from claims of infringement, implied
--  warranties of merchantability or fitness for a particular
--  purpose.
--
--  Xilinx products are not intended for use in life support
--  appliances, devices, or systems. Use in such applications are
--  expressly prohibited.
--
--  This copyright and support notice must be retained as part
--  of this text at all times. (c) Copyright 1995-2007 Xilinx, Inc.
--  All rights reserved.
--------------------------------------------------------------------------------
--
-- Behavorial simulation model for parallel Reed-Solomon encoder
--
-- $RCSfile: rs_encoder_unobf_v6_1.vhd,v $ $Revision: 1.7 $ $Date: 2008/09/09 15:24:49 $
--
--------------------------------------------------------------------------------
--
-- The design is parameterizable via the following GENERICs:
--
--     gen_start    - Start index for generator polynomial g(x).
--                    g(x) = mult[i=0 to n-k] of (x - alpha pow(h * (gen_start +i))).
--
--     h            - Scaling factor for the generator polynomial polynomial g(x).
--                    g(x) = mult[i=0 to n-k] of (x - alpha pow(h * (gen_start +i))).
--
--     k            - Number of data symbols in a code block.
--                    This is used to calculate the number of check symbols n - k.
--                    If c_has_n_in is asserted or c_has_r_in is asserted the number 
--                    of data symbols will depend on the n_in and r_in inputs.
--
--     memstyle     - dist_mem  (0) => Do not use any block memories
--                  - block_mem (1) => Use block memories wherever possible
--                  - auto_mem  (2) => Allow core to choose memory styles
--
--     n            - Total number of symbols (data + check) in a code block
--                    If c_has_n_in is not asserted then n specifies the total 
--                    number of symbols (data + check) in a code block.
--                    If c_has_n_in is asserted then n specifies the maximum
--                    number of symbols in a code block the actual number of symbols 
--                    is determined from the n_in input at the start of the block.
--
--     num_channels - Number of Encoder channles implemented in serial.
--
--     polynomial   - Galois Field polynomial. See gf_pkg.vhd for more
--                    information on this. Supplying a value of 0 will cause
--                    the default polynomial for the given symbol width to
--                    be selected.
--
--     symbol_width - Symbol size in bits. This is the bus width of the data_in
--                    and data_out ports.
--
--     c_spec       - Spec code - see gf_pkg.vhd. Determines whether dual-basis
--                    ROMs are required
--
--
--------------------------------------------------------------------------------
-- The following PORTs are provided:
--
--     data_in      - Bus for incoming symbols to be decoded.
--
--     n_in         - Optional Block Length input. This is only used when 
--                    c_has_n_in is asserted. This input specifies total number 
--                    of symbols (data + check) in the code block. This value is 
--                    read during the first cycle of a block and specifies the 
--                    length of the same block. 
--                    
--     r_in         - Optional  input. This is only used when c_has_r_in is 
--                    asserted. This input specifies total number of check symbols 
--                    in the code block. This value is read during the first cycle 
--                    of a block and specifies the check symbols of the same block. 
--
--     start        - When 'start' is asserted on the rising clk edge that cycle is
--                    the first cycle of a new code block.
--
--     bypass       - When 'bypass' is asserted the data_in is passed straight
--                    through to data_out (with standard latency) without affecting 
--                    the check symbol calculation
--
--     nd           - Optional New Data input. Use if it is required to process
--                    data as much as possible once it has been sampled. High
--                    if data should be sampled, low if data should be ignored.
--                    Ignored if bypass is high.
--
--     data_out     - Bus for output of encoded symbols.
--
--     info         - High when data symbols being output. Low when check symbols
--                    being output. Also high when bypass symbols being output.
--
--     rdy          - Optional output pin. High when valid data or check symbol
--                    being output.
--
--     rfd          - Optional output pin. High when core is ready to sample
--                    new input data.
--
--     rffd         - Optional output pin.  (Ready For First Data). High when
--                    core is ready to start a new block.
--     reset        - Asynchronous reset. When 'reset' is pulsed high, the core
--                    is asynchronously initialised.
--
--     ce           - The clock enable input is an optional pin, controlled by
--                    the 'c_has_ce' GENERIC. It is recommended to use the core
--                    without a ce input if possible. However it can be useful
--                    if some of the incoming symbols are to not to be included
--                    in the code block.
--
--     clk          - The core is a completely synchronous design. All inputs,
--                    except 'reset', must be synchronous to the 'clk' input.
--
--------------------------------------------------------------------------------

LIBRARY IEEE;USE IEEE.STD_LOGIC_1164.ALL;LIBRARY XILINXCORELIB;USE XILINXCORELIB.RS_ENCODER_V6_1_CONSTS.ALL;ENTITY RS_ENCODER_V6_1
 IS GENERIC(C_FAMILY:STRING:=C_FAMILY_DEFAULT;C_GEN_POLY_TYPE:INTEGER:=C_GEN_POLY_TYPE_DEFAULT;C_GEN_START:INTEGER:=
C_GEN_START_DEFAULT;C_H:INTEGER:=C_H_DEFAULT;C_HAS_CE:INTEGER:=C_CE_DEFAULT;C_HAS_N_IN:INTEGER:=C_N_IN_DEFAULT;C_HAS_ND:INTEGER:=
C_ND_DEFAULT;C_HAS_R_IN:INTEGER:=C_R_IN_DEFAULT;C_HAS_RDY:INTEGER:=C_RDY_DEFAULT;C_HAS_RFD:INTEGER:=C_RFD_DEFAULT;C_HAS_RFFD:INTEGER
:=C_RFFD_DEFAULT;C_K:INTEGER:=C_K_DEFAULT;C_MEM_INIT_PREFIX:STRING:=C_MEM_INIT_PREFIX_DEFAULT;C_ELABORATION_DIR:STRING:=
C_ELABORATION_DIR_DEFAULT;C_MEMSTYLE:INTEGER:=C_MEMSTYLE_DEFAULT;C_N:INTEGER:=C_N_DEFAULT;C_NUM_CHANNELS:INTEGER:=
C_NUM_CHANNELS_DEFAULT;C_OPTIMIZATION:INTEGER:=C_OPTIMIZATION_DEFAULT;C_POLYNOMIAL:INTEGER:=C_POLYNOMIAL_DEFAULT;C_SPEC:INTEGER:=
C_SPEC_DEFAULT;C_SYMBOL_WIDTH:INTEGER:=C_SYMBOL_WIDTH_DEFAULT;C_USERPM:INTEGER:=C_USERPM_DEFAULT);PORT(DATA_IN:IN STD_LOGIC_VECTOR(
C_SYMBOL_WIDTH-1 DOWNTO 0);N_IN:IN STD_LOGIC_VECTOR(C_SYMBOL_WIDTH-1 DOWNTO 0):=(OTHERS=>'1');R_IN:IN STD_LOGIC_VECTOR(INTEGER_WIDTH
(C_N-C_K)-1 DOWNTO 0):=(OTHERS=>'1');START:IN STD_LOGIC;BYPASS:IN STD_LOGIC:='0';ND:IN STD_LOGIC:='1';DATA_OUT:OUT STD_LOGIC_VECTOR
(C_SYMBOL_WIDTH-1 DOWNTO 0);INFO:OUT STD_LOGIC;RDY:OUT STD_LOGIC;RFD:OUT STD_LOGIC;RFFD:OUT STD_LOGIC;CE:IN STD_LOGIC:='1';RESET:IN
 STD_LOGIC:='0';CLK:IN STD_LOGIC);END;ARCHITECTURE BEHAVIORAL OF RS_ENCODER_V6_1 IS CONSTANT II1IOOO1II0l1lOl00I1O001I00O0IIIII:INTEGER:=C_GEN_START;CONSTANT
 IO1lll0I0l0l1ll1O01Ol0III011IOIIII:INTEGER:=C_H;CONSTANT IOO0111OO0lOOl10l1l000l0OlI0IIIIII:INTEGER:=C_K;CONSTANT IIlO1lIIlOlOOO0l10OI1ll0I0O10IIIII:INTEGER:=C_N;CONSTANT IOOOlI0llOIl11IO01100OI1llOIIOIIII:INTEGER:=C_POLYNOMIAL;CONSTANT IO1IOOl1111OI1OOII1IOl0lIIIIOIIIII:
INTEGER:=C_SYMBOL_WIDTH;CONSTANT II1001IO0010Oll1I01lOI0I0IlIOIIIII:INTEGER:=12;CONSTANT IO110I1O0010OIOlIO00l1IIOl0llIIIII:INTEGER:=2;CONSTANT IIIOOIO01011011IOIIlllIIOO0l1IIIII:INTEGER:=1;CONSTANT
 II1IOOO00I0OI0O01I000O100llOOIIIII:INTEGER:=0;CONSTANT II00OI0110lI1II101lO1OO00I10OIIIII:INTEGER:=0;CONSTANT II00OIlIlO101I0IIOO0O1I0ll0OIIIIII:INTEGER:=2;TYPE IOOI1l1OO01O111lO010OlO1O0l0IIIIII IS ARRAY(0 TO
 II1001IO0010Oll1I01lOI0I0IlIOIIIII-1)OF INTEGER;CONSTANT IO11OllII1lO110Ol0I0O00I01l00IIIII:IOOI1l1OO01O111lO010OlO1O0l0IIIIII:=(141,239,236,134,250,153,175,123,0,0,0,0);CONSTANT
 III01lO1l00IOOO0O0I0O0I111O0IIIIII:IOOI1l1OO01O111lO010OlO1O0l0IIIIII:=(197,66,46,253,240,121,172,204,0,0,0,0);CONSTANT IO1I1l01l1OI111Ol0IO10110I11IOIIII:INTEGER:=IO1IOOl1111OI1OOII1IOl0lIIIIOIIIII;CONSTANT IOOll1I1OOlO0lOO0IIII1lO11IIlIIIII:
INTEGER:=IO1I1l01l1OI111Ol0IO10110I11IOIIII-1;CONSTANT IIIOI11O0OO00OllOllO00lOI000IOIIII:INTEGER:=IIlO1lIIlOlOOO0l10OI1ll0I0O10IIIII-IOO0111OO0lOOl10l1l000l0OlI0IIIIII;CONSTANT IIOIOOO11l0lO001OI10I0IIIIlIIIIIII:INTEGER:=IIIOI11O0OO00OllOllO00lOI000IOIIII-1;CONSTANT II0IO0I0Olll01OOO0lIOO01lOlIOOIIII:INTEGER:=C_NUM_CHANNELS-1;CONSTANT IOO10IlOOIIIlOIO1IOI1l1lOIIlOIIIII:INTEGER
:=2**IO1I1l01l1OI111Ol0IO10110I11IOIIII;CONSTANT II0l0OlOIIIO1I0IOlIIllOIOO10lIIIII:INTEGER:=IOO10IlOOIIIlOIO1IOI1l1lOIIlOIIIII-1;CONSTANT IO0lIOlI0II1000IOlOIlOI1lIlOOIIIII:INTEGER:=IOO10IlOOIIIlOIO1IOI1l1lOIIlOIIIII-2;CONSTANT IO0O10O101OOIOOl10lIIO101lIIIIIIII:INTEGER:=IOO10IlOOIIIlOIO1IOI1l1lOIIlOIIIII-3;TYPE IIOl10001I1Ol001OIO01IO1II10OIIIII IS
 ARRAY(0 TO IO0lIOlI0II1000IOlOIlOI1lIlOOIIIII)OF INTEGER;TYPE IIIO0lOII1OIlOOIO1IlI1lIIO001IIIII IS ARRAY(0 TO II0l0OlOIIIO1I0IOlIIllOIOO10lIIIII)OF INTEGER;CONSTANT IIIIl1100lOI0I1OO1I00OlI0l10IIIIII:TIME:=1 NS;FUNCTION
 IOlI00I100IOOOl011O11IOI1l010IIIII(IIIO1O1110Oll10OI110OIIO111OOIIIII:INTEGER)RETURN BOOLEAN IS VARIABLE IIl0OIlO00I0lI101l1I0lO1II0IlIIIII:BOOLEAN:=TRUE;BEGIN IF(II1IOOO1II0l1lOl00I1O001I00O0IIIII<0)THEN ASSERT FALSE REPORT
"ERROR: gen_start must be greater than or equal to 0."SEVERITY FAILURE;IIl0OIlO00I0lI101l1I0lO1II0IlIIIII:=FALSE;END IF;IF(IO1lll0I0l0l1ll1O01Ol0III011IOIIII<1)THEN ASSERT FALSE REPORT
"ERROR: h must be greater than or equal to 1."SEVERITY FAILURE;IIl0OIlO00I0lI101l1I0lO1II0IlIIIII:=FALSE;END IF;IF(IOO0111OO0lOOl10l1l000l0OlI0IIIIII<1 OR IOO0111OO0lOOl10l1l000l0OlI0IIIIII>(II0l0OlOIIIO1I0IOlIIllOIOO10lIIIII-2))THEN ASSERT FALSE
 REPORT"ERROR: k must be between 1 and (2**symbol_width - 3)."SEVERITY FAILURE;IIl0OIlO00I0lI101l1I0lO1II0IlIIIII:=FALSE;END IF;IF(IIlO1lIIlOlOOO0l10OI1ll0I0O10IIIII<3 OR IIlO1lIIlOlOOO0l10OI1ll0I0O10IIIII>II0l0OlOIIIO1I0IOlIIllOIOO10lIIIII)THEN
 ASSERT FALSE REPORT"ERROR: n must be between 3 and (2**symbol_width - 1)."SEVERITY FAILURE;IIl0OIlO00I0lI101l1I0lO1II0IlIIIII:=FALSE;END IF;IF(IOOOlI0llOIl11IO01100OI1llOIIOIIII
<0)THEN ASSERT FALSE REPORT"ERROR: polynomial must be greater than or equal to 0."SEVERITY FAILURE;IIl0OIlO00I0lI101l1I0lO1II0IlIIIII:=FALSE;END IF;IF(
IO1IOOl1111OI1OOII1IOl0lIIIIOIIIII<3 OR IO1IOOl1111OI1OOII1IOl0lIIIIOIIIII>12)THEN ASSERT FALSE REPORT"ERROR: symbol_width must be between 3 and 12."SEVERITY FAILURE;
IIl0OIlO00I0lI101l1I0lO1II0IlIIIII:=FALSE;END IF;IF(C_SPEC<II00OI0110lI1II101lO1OO00I10OIIIII OR C_SPEC>II00OIlIlO101I0IIOO0O1I0ll0OIIIIII)THEN ASSERT FALSE REPORT
"ERROR: specification must be between 0 and 2."SEVERITY FAILURE;IIl0OIlO00I0lI101l1I0lO1II0IlIIIII:=FALSE;END IF;IF(C_MEMSTYLE<0 OR C_MEMSTYLE>2)THEN
 ASSERT FALSE REPORT"ERROR: memory style must be between 0 and 2."SEVERITY FAILURE;IIl0OIlO00I0lI101l1I0lO1II0IlIIIII:=FALSE;END IF;IF(C_USERPM<0 OR
 C_USERPM>1)THEN ASSERT FALSE REPORT"ERROR: use rpm must be between 0 and 1."SEVERITY FAILURE;IIl0OIlO00I0lI101l1I0lO1II0IlIIIII:=FALSE;END IF;IF(
IO1IOOl1111OI1OOII1IOl0lIIIIOIIIII>8)THEN IF(IIIOI11O0OO00OllOllO00lOI000IOIIII<2 OR IIIOI11O0OO00OllOllO00lOI000IOIIII>256)THEN ASSERT FALSE REPORT"ERROR: Number of stages (n - k) must be between 2 and 256."SEVERITY
 FAILURE;IIl0OIlO00I0lI101l1I0lO1II0IlIIIII:=FALSE;END IF;ELSE IF(IIIOI11O0OO00OllOllO00lOI000IOIIII<2 OR IIIOI11O0OO00OllOllO00lOI000IOIIII>IO0lIOlI0II1000IOlOIlOI1lIlOOIIIII)THEN ASSERT FALSE REPORT
"ERROR: Number of stages (n - k) must be between 2 and (2**symbol_width-2)."SEVERITY FAILURE;IIl0OIlO00I0lI101l1I0lO1II0IlIIIII:=FALSE;END IF;END IF;IF((
C_HAS_N_IN=1)AND(IIlO1lIIlOlOOO0l10OI1ll0I0O10IIIII/=II0l0OlOIIIO1I0IOlIIllOIOO10lIIIII))THEN ASSERT FALSE REPORT
"ERROR: n must be (2**symbol_width - 1) for variable block length implementations."SEVERITY FAILURE;IIl0OIlO00I0lI101l1I0lO1II0IlIIIII:=FALSE;END IF;IF((
C_HAS_R_IN=1)AND(C_HAS_N_IN/=1))THEN ASSERT FALSE REPORT
"ERROR: Variable block length is required for variable number of check symbol implementations."SEVERITY FAILURE;IIl0OIlO00I0lI101l1I0lO1II0IlIIIII:=FALSE;
END IF;IF((C_HAS_R_IN=0)AND(C_GEN_POLY_TYPE/=0))THEN ASSERT FALSE REPORT
"ERROR: Fixed polynomial generator type is required for fixed number of check symbol implementations."SEVERITY FAILURE;IIl0OIlO00I0lI101l1I0lO1II0IlIIIII
:=FALSE;END IF;IF((C_HAS_R_IN=1)AND(C_GEN_POLY_TYPE=0))THEN ASSERT FALSE REPORT
"ERROR: Fixed polynomial generator type is not allowed for variable number of check symbol implementations."SEVERITY FAILURE;
IIl0OIlO00I0lI101l1I0lO1II0IlIIIII:=FALSE;END IF;RETURN IIl0OIlO00I0lI101l1I0lO1II0IlIIIII;END;CONSTANT IOIlII1I0O0l1l1O110O0IOlO0O1lIIIII:BOOLEAN:=IOlI00I100IOOOl011O11IOI1l010IIIII(0);FUNCTION II11I0011I0IIIl0100l1O01O01O0IIIII(II011lO0O1l10O0I0OIOO000I0O1IOIIII:STD_LOGIC)RETURN
 STD_LOGIC IS BEGIN CASE II011lO0O1l10O0I0OIOO000I0O1IOIIII IS WHEN '0'|'1'=>RETURN II011lO0O1l10O0I0OIOO000I0O1IOIIII;WHEN 'H'=>RETURN '1';WHEN 'L'=>RETURN '0';WHEN OTHERS=>RETURN 'X';END
 CASE;END;FUNCTION IO1IIIl1OO00II0ll110l0l0IIO0lIIIII(IIlOllOOI0ll11O1101IIl0l11ll1IIIII:STD_LOGIC_VECTOR)RETURN BOOLEAN IS BEGIN FOR II1I0lOOIIOI1l0l10l0O0l0Ol0OIIIIII IN IIlOllOOI0ll11O1101IIl0l11ll1IIIII'RANGE LOOP IF(II11I0011I0IIIl0100l1O01O01O0IIIII(IIlOllOOI0ll11O1101IIl0l11ll1IIIII(II1I0lOOIIOI1l0l10l0O0l0Ol0OIIIIII))='X')THEN RETURN TRUE
;END IF;END LOOP;RETURN FALSE;END;FUNCTION III1OO10l11110IO1IO0lOII0OO11IIIII(IO1O1llOO0IlllI1O1OlOI010l1IIIIIII:STD_LOGIC_VECTOR)RETURN STD_LOGIC_VECTOR IS VARIABLE IO1O0llO0I1lI11I1O10I0l1O0l0IIIIII:
STD_LOGIC_VECTOR(IO1O1llOO0IlllI1O1OlOI010l1IIIIIII'HIGH DOWNTO 0):=(OTHERS=>'0');VARIABLE II1IO01lI1IO1OII11O1II01I0llIOIIII:INTEGER:=0;BEGIN FOR II1lIII001001Il0l0OOl0I00I01IIIIII IN 0 TO IO1O1llOO0IlllI1O1OlOI010l1IIIIIII'HIGH LOOP IF(II1IO01lI1IO1OII11O1II01I0llIOIIII=1)THEN
 IF(IO1O1llOO0IlllI1O1OlOI010l1IIIIIII(II1lIII001001Il0l0OOl0I00I01IIIIII)='0')THEN IO1O0llO0I1lI11I1O10I0l1O0l0IIIIII(II1lIII001001Il0l0OOl0I00I01IIIIII):='1';ELSE IO1O0llO0I1lI11I1O10I0l1O0l0IIIIII(II1lIII001001Il0l0OOl0I00I01IIIIII):='0';END IF;ELSE IO1O0llO0I1lI11I1O10I0l1O0l0IIIIII(II1lIII001001Il0l0OOl0I00I01IIIIII):=IO1O1llOO0IlllI1O1OlOI010l1IIIIIII(II1lIII001001Il0l0OOl0I00I01IIIIII);IF(IO1O1llOO0IlllI1O1OlOI010l1IIIIIII(II1lIII001001Il0l0OOl0I00I01IIIIII)='1')THEN II1IO01lI1IO1OII11O1II01I0llIOIIII:=1;END
 IF;END IF;END LOOP;RETURN IO1O0llO0I1lI11I1O10I0l1O0l0IIIIII;END;FUNCTION II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII(IOII100I0I1l010IOI1lO1O1I1101IIIII,IOO10OI11Il110I11IIIIIOIO10OlIIIII:INTEGER)RETURN STD_LOGIC_VECTOR IS VARIABLE
 IOO1I1lI11Ol1l1OOlllIIII1l1IOIIIII:INTEGER:=IOII100I0I1l010IOI1lO1O1I1101IIIII;VARIABLE IOl0l10lI11IO10lI1OI1IOI01OO0IIIII:STD_LOGIC_VECTOR(IOO10OI11Il110I11IIIIIOIO10OlIIIII-1 DOWNTO 0):=(OTHERS=>'0');BEGIN IF(IOII100I0I1l010IOI1lO1O1I1101IIIII<0)THEN
 IOO1I1lI11Ol1l1OOlllIIII1l1IOIIIII:=-1*IOII100I0I1l010IOI1lO1O1I1101IIIII;END IF;FOR IOO1l1010O10O10I0llO11O100O1IOIIII IN 0 TO IOO10OI11Il110I11IIIIIOIO10OlIIIII-1 LOOP IF IOO1I1lI11Ol1l1OOlllIIII1l1IOIIIII MOD 2=0 THEN IOl0l10lI11IO10lI1OI1IOI01OO0IIIII(IOO1l1010O10O10I0llO11O100O1IOIIII):='0';ELSE
 IOl0l10lI11IO10lI1OI1IOI01OO0IIIII(IOO1l1010O10O10I0llO11O100O1IOIIII):='1';END IF;IOO1I1lI11Ol1l1OOlllIIII1l1IOIIIII:=IOO1I1lI11Ol1l1OOlllIIII1l1IOIIIII/2;END LOOP;IF(IOII100I0I1l010IOI1lO1O1I1101IIIII<0)THEN RETURN III1OO10l11110IO1IO0lOII0OO11IIIII(IOl0l10lI11IO10lI1OI1IOI01OO0IIIII);ELSE RETURN
 IOl0l10lI11IO10lI1OI1IOI01OO0IIIII;END IF;END;FUNCTION IOIlOIOl1lO1l001Ol10IO01OIlI1IIIII(II0IOOI1Il101lO1O010O0O0IO10IOIIII:IN STD_LOGIC_VECTOR)RETURN NATURAL IS VARIABLE IO1lIIIOl1IIIO1O1lllOO0I1lO0OIIIII:NATURAL
:=0;VARIABLE IOOIOOI00l1OOOlI1OOO0I00Ol0IlIIIII:BOOLEAN:=FALSE;BEGIN FOR II111OIOII1IIOOOlO1I011OI0I0lIIIII IN II0IOOI1Il101lO1O010O0O0IO10IOIIII'RANGE LOOP IO1lIIIOl1IIIO1O1lllOO0I1lO0OIIIII:=IO1lIIIOl1IIIO1O1lllOO0I1lO0OIIIII*2;IF(II0IOOI1Il101lO1O010O0O0IO10IOIIII(II111OIOII1IIOOOlO1I011OI0I0lIIIII)='1'OR II0IOOI1Il101lO1O010O0O0IO10IOIIII(II111OIOII1IIOOOlO1I011OI0I0lIIIII)='H')THEN IO1lIIIOl1IIIO1O1lllOO0I1lO0OIIIII
:=IO1lIIIOl1IIIO1O1lllOO0I1lO0OIIIII+1;ELSIF(II0IOOI1Il101lO1O010O0O0IO10IOIIII(II111OIOII1IIOOOlO1I011OI0I0lIIIII)/='0'AND II0IOOI1Il101lO1O010O0O0IO10IOIIII(II111OIOII1IIOOOlO1I011OI0I0lIIIII)/='L')THEN IOOIOOI00l1OOOlI1OOO0I00Ol0IlIIIII:=TRUE;END IF;END LOOP;IF IOOIOOI00l1OOOlI1OOO0I00Ol0IlIIIII THEN ASSERT FALSE REPORT
"ERROR: std_logic_vector_to_natural: There is a non-numeric bit in the argument."&" It has been converted to 0."SEVERITY WARNING;END
 IF;RETURN IO1lIIIOl1IIIO1O1lllOO0I1lO0OIIIII;END;FUNCTION III0OI0OlIOOl1Ol1I0l00O0lI1IIIIIII(IIIIlI10IO0IlIll11O0O1OII0OIIOIIII:IN NATURAL;IIIO10O1ll1l0O0IOl0l1lllO0lI1IIIII:IN NATURAL)RETURN STD_LOGIC_VECTOR IS VARIABLE
 IIIlOO0OOl101Ol0Oll10O1lOIIO0IIIII:NATURAL:=IIIIlI10IO0IlIll11O0O1OII0OIIOIIII;VARIABLE IIl1O1I0001l1001OllOOII0I10l1IIIII:STD_LOGIC_VECTOR(IIIO10O1ll1l0O0IOl0l1lllO0lI1IIIII-1 DOWNTO 0):=(OTHERS=>'0');CONSTANT IIlIlll0III10I0Il0I0OOOIOIIOOIIIII:STD_LOGIC_VECTOR(0 TO 1):=
(0=>'0',1=>'1');BEGIN FOR IOOI10l0O1lIlIll00Ol1lll10IIIIIIII IN IIl1O1I0001l1001OllOOII0I10l1IIIII'REVERSE_RANGE LOOP IIl1O1I0001l1001OllOOII0I10l1IIIII(IOOI10l0O1lIlIll00Ol1lll10IIIIIIII):=IIlIlll0III10I0Il0I0OOOIOIIOOIIIII(IIIlOO0OOl101Ol0Oll10O1lOIIO0IIIII REM 2);IIIlOO0OOl101Ol0Oll10O1lOIIO0IIIII:=IIIlOO0OOl101Ol0Oll10O1lOIIO0IIIII/2;EXIT WHEN IIIlOO0OOl101Ol0Oll10O1lOIIO0IIIII=0;END LOOP;
RETURN IIl1O1I0001l1001OllOOII0I10l1IIIII;END;TYPE IO0OOOI1IIIlIOIIOO0Il00I1lOOlIIIII IS ARRAY(0 TO 12)OF INTEGER;CONSTANT IOl0I10010lIIIl000I1O1IO1IlOIIIIII:IO0OOOI1IIIlIOIIOO0Il00I1lOOlIIIII:=(0=>0,1=>0
,2=>7,3=>11,4=>19,5=>37,6=>67,7=>137,8=>285,9=>529,10=>1033,11=>2053,12=>4179);FUNCTION IOl1I1O0IIO001llOlll1I1lOI1l0IIIII(IOl1Ol11IlIl0110l0OOll000lI11IIIII:IN INTEGER;II001Il0III1O1OI001IOI100000OIIIII
:IN INTEGER)RETURN INTEGER IS VARIABLE IOOl0llO0OI110111OIOlOIO0lOOIOIIII:INTEGER:=0;BEGIN IF IOl1Ol11IlIl0110l0OOll000lI11IIIII=0 THEN IOOl0llO0OI110111OIOlOIO0lOOIOIIII:=IOl0I10010lIIIl000I1O1IO1IlOIIIIII(II001Il0III1O1OI001IOI100000OIIIII);ELSE
 IOOl0llO0OI110111OIOlOIO0lOOIOIIII:=IOl1Ol11IlIl0110l0OOll000lI11IIIII;END IF;ASSERT IOOl0llO0OI110111OIOlOIO0lOOIOIIII/=0 REPORT
"ERROR: No polynomial supplied and no default available for specified symbol width."SEVERITY FAILURE;RETURN IOOl0llO0OI110111OIOlOIO0lOOIOIIII;END;FUNCTION
 II1IOO1l1I11I1ll1OI1I00lII000IIIII(II0II1IO1I0IOIl0ll1I0O00lIIOOIIIII,IOOl0IOOO1011llOIOl01lIOI0O11IIIII,IIOlOO00Ol0011IIIIIO1I1lllIO0IIIII:NATURAL)RETURN NATURAL IS VARIABLE II1I0O0100lIIII11lI00l0OOII0lIIIII:NATURAL:=II0II1IO1I0IOIl0ll1I0O00lIIOOIIIII;VARIABLE IIOIOI0lO1lO100O11Il0OII11OlOIIIII:NATURAL:=IOOl0IOOO1011llOIOl01lIOI0O11IIIII;VARIABLE IO0IlO1lI10Il011101l101IIl0IOIIIII:NATURAL:=0
;VARIABLE IOI1O00I10101l0I1001llOOI0I0IOIIII:NATURAL:=0;VARIABLE IIOIO000I1OI0OlOI1OIOI1l0I0l1IIIII:NATURAL:=1;VARIABLE IO1Il1I0OOOOIl0IOO011l1I0111OIIIII:NATURAL:=0;VARIABLE IO0l0IOllOl1100O10O1O1l0lIO1OIIIII:NATURAL:=0;BEGIN IIOIO000I1OI0OlOI1OIOI1l0I0l1IIIII
:=1;FOR IIlOO000I01110Ill0l1OI1l10IOIOIIII IN 0 TO(IIOlOO00Ol0011IIIIIO1I1lllIO0IIIII-1)LOOP IO0IlO1lI10Il011101l101IIl0IOIIIII:=II1I0O0100lIIII11lI00l0OOII0lIIIII REM 2;IOI1O00I10101l0I1001llOOI0I0IOIIII:=IIOIOI0lO1lO100O11Il0OII11OlOIIIII REM 2;IO1Il1I0OOOOIl0IOO011l1I0111OIIIII:=IO0IlO1lI10Il011101l101IIl0IOIIIII+IOI1O00I10101l0I1001llOOI0I0IOIIII;IF(IO1Il1I0OOOOIl0IOO011l1I0111OIIIII=1)THEN IO0l0IOllOl1100O10O1O1l0lIO1OIIIII:=
IO0l0IOllOl1100O10O1O1l0lIO1OIIIII+IIOIO000I1OI0OlOI1OIOI1l0I0l1IIIII;END IF;II1I0O0100lIIII11lI00l0OOII0lIIIII:=II1I0O0100lIIII11lI00l0OOII0lIIIII/2;IIOIOI0lO1lO100O11Il0OII11OlOIIIII:=IIOIOI0lO1lO100O11Il0OII11OlOIIIII/2;IIOIO000I1OI0OlOI1OIOI1l0I0l1IIIII:=IIOIO000I1OI0OlOI1OIOI1l0I0l1IIIII*2;END LOOP;RETURN IO0l0IOllOl1100O10O1O1l0lIO1OIIIII;END;FUNCTION
 II1011O1IO1l0llOI11lIIOIlOlIlIIIII(IOO0I1l1IOO0II0O00I0IllOOI1OOIIIII:INTEGER)RETURN IIOl10001I1Ol001OIO01IO1II10OIIIII IS VARIABLE IOI01l1I0000lIO0IIO01IlIO1001IIIII:IIOl10001I1Ol001OIO01IO1II10OIIIII:=(OTHERS=>0);VARIABLE IOI0IIll0I0l1IO0I01lO110IIIIIOIIII
:INTEGER:=0;VARIABLE IO00l1I0I1IOlII011Il0l0lOI0OIIIIII:INTEGER:=0;VARIABLE IO01l1ll0IlOll0I00lll11l0OllIIIIII:INTEGER:=0;BEGIN IOI0IIll0I0l1IO0I01lO110IIIIIOIIII:=IOl1I1O0IIO001llOlll1I1lOI1l0IIIII(IOOOlI0llOIl11IO01100OI1llOIIOIIII,IO1I1l01l1OI111Ol0IO10110I11IOIIII);IO00l1I0I1IOlII011Il0l0lOI0OIIIIII:=1;FOR IOI11IOIlOI1II1Il11OlI01Illl0IIIII IN 0 TO
 IOOll1I1OOlO0lOO0IIII1lO11IIlIIIII LOOP IOI01l1I0000lIO0IIO01IlIO1001IIIII(IOI11IOIlOI1II1Il11OlI01Illl0IIIII):=IO00l1I0I1IOlII011Il0l0lOI0OIIIIII;IO00l1I0I1IOlII011Il0l0lOI0OIIIIII:=IO00l1I0I1IOlII011Il0l0lOI0OIIIIII*2;END LOOP;IOI01l1I0000lIO0IIO01IlIO1001IIIII(IO1I1l01l1OI111Ol0IO10110I11IOIIII):=IOI0IIll0I0l1IO0I01lO110IIIIIOIIII REM IOO10IlOOIIIlOIO1IOI1l1lOIIlOIIIII;IO00l1I0I1IOlII011Il0l0lOI0OIIIIII:=IO00l1I0I1IOlII011Il0l0lOI0OIIIIII/2;FOR IIlO0IOl0I0I0lI0OOll1l1l1lO0IIIIII IN(IO1I1l01l1OI111Ol0IO10110I11IOIIII+1)TO IO0lIOlI0II1000IOlOIlOI1lIlOOIIIII LOOP IF(
IOI01l1I0000lIO0IIO01IlIO1001IIIII(IIlO0IOl0I0I0lI0OOll1l1l1lO0IIIIII-1)>=IO00l1I0I1IOlII011Il0l0lOI0OIIIIII)THEN IO01l1ll0IlOll0I00lll11l0OllIIIIII:=2*(IOI01l1I0000lIO0IIO01IlIO1001IIIII(IIlO0IOl0I0I0lI0OOll1l1l1lO0IIIIII-1)-IO00l1I0I1IOlII011Il0l0lOI0OIIIIII);IOI01l1I0000lIO0IIO01IlIO1001IIIII(IIlO0IOl0I0I0lI0OOll1l1l1lO0IIIIII):=II1IOO1l1I11I1ll1OI1I00lII000IIIII(IOI0IIll0I0l1IO0I01lO110IIIIIOIIII,IO01l1ll0IlOll0I00lll11l0OllIIIIII,IO1I1l01l1OI111Ol0IO10110I11IOIIII);ELSE IOI01l1I0000lIO0IIO01IlIO1001IIIII(IIlO0IOl0I0I0lI0OOll1l1l1lO0IIIIII):=IOI01l1I0000lIO0IIO01IlIO1001IIIII(IIlO0IOl0I0I0lI0OOll1l1l1lO0IIIIII-1)*2
;END IF;END LOOP;RETURN IOI01l1I0000lIO0IIO01IlIO1001IIIII;END;CONSTANT IOlIOOI0O1OIlOl01O0OIII10O11lIIIII:IIOl10001I1Ol001OIO01IO1II10OIIIII:=II1011O1IO1l0llOI11lIIOIlOlIlIIIII(0);FUNCTION IO1OIOI0I1l11O0IllIOllII1llIIOIIII(IIOOO0OOIll110IlI1111I1001I01IIIII:
INTEGER)RETURN IIIO0lOII1OIlOOIO1IlI1lIIO001IIIII IS VARIABLE IO00lII1lIll0OllOlI1l1O0OI100IIIII:IIIO0lOII1OIlOOIO1IlI1lIIO001IIIII:=(OTHERS=>0);BEGIN FOR IIII1llIll1l01O1l1O0OIlO1l00OIIIII IN 0 TO II0l0OlOIIIO1I0IOlIIllOIOO10lIIIII LOOP IO00lII1lIll0OllOlI1l1O0OI100IIIII(IIII1llIll1l01O1l1O0OIlO1l00OIIIII
):=0;END LOOP;FOR II10ll00IlO1IIOIOIO10II0lI1l0IIIII IN 0 TO IO0lIOlI0II1000IOlOIlOI1lIlOOIIIII LOOP IO00lII1lIll0OllOlI1l1O0OI100IIIII(IOlIOOI0O1OIlOl01O0OIII10O11lIIIII(II10ll00IlO1IIOIOIO10II0lI1l0IIIII)):=II10ll00IlO1IIOIOIO10II0lI1l0IIIII;END LOOP;RETURN IO00lII1lIll0OllOlI1l1O0OI100IIIII;END;CONSTANT IOIIOIIO1lIIOOl0IlO11I00II110IIIII:IIIO0lOII1OIlOOIO1IlI1lIIO001IIIII
:=IO1OIOI0I1l11O0IllIOllII1llIIOIIII(0);FUNCTION II0Ol0OI111lIO001O0IIlO110IlIOIIII(II1ll00lO01110lOI1I0IOO0IlO0IIIIII:INTEGER)RETURN BOOLEAN IS VARIABLE IO0I011OOl0OOO000O0I0O0OO0OllIIIII:BOOLEAN:=TRUE;BEGIN FOR IO1OllI0IIll0OIOI1l01I010OOIOOIIII
 IN 2 TO II0l0OlOIIIO1I0IOlIIllOIOO10lIIIII LOOP IF IOIIOIIO1lIIOOl0IlO11I00II110IIIII(IO1OllI0IIll0OIOI1l01I010OOIOOIIII)=0 THEN IO0I011OOl0OOO000O0I0O0OO0OllIIIII:=FALSE;EXIT;END IF;END LOOP;ASSERT IO0I011OOl0OOO000O0I0O0OO0OllIIIII=TRUE REPORT
"ERROR: Specified polynomial is not primitive for specified symbol width. Expect erroneous behavior!"SEVERITY FAILURE;RETURN
 IO0I011OOl0OOO000O0I0O0OO0OllIIIII;END;CONSTANT IIOl11l1l101llOl0l0l101I1O1llIIIII:BOOLEAN:=II0Ol0OI111lIO001O0IIlO110IlIOIIII(0);TYPE III1O0Ol0IOOO0IllIOOO000O1lO0IIIII IS ARRAY(0 TO IIOIOOO11l0lO001OI10I0IIIIlIIIIIII)OF INTEGER;TYPE
 IIl1IIO111llI0l1O1OI00lIl1I0OIIIII IS ARRAY(0 TO IIOIOOO11l0lO001OI10I0IIIIlIIIIIII)OF III1O0Ol0IOOO0IllIOOO000O1lO0IIIII;SUBTYPE IIIOOI1II1O11lOIOlOIlOOII1010IIIII IS STD_LOGIC_VECTOR(IOOll1I1OOlO0lOO0IIII1lO11IIlIIIII DOWNTO 0);TYPE
 IO0I0I00IO00I1O0I0O0OIOOOI11IOIIII IS ARRAY(0 TO IIOIOOO11l0lO001OI10I0IIIIlIIIIIII)OF IIIOOI1II1O11lOIOlOIlOOII1010IIIII;TYPE IIlIOIlO1lO1l1I0OOOI1O1l0O0IOIIIII IS ARRAY(0 TO II0IO0I0Olll01OOO0lIOO01lOlIOOIIII)OF
 IO0I0I00IO00I1O0I0O0OIOOOI11IOIIII;TYPE IOOI0OO0l1O1O000lO10OOllOIIIIOIIII IS ARRAY(0 TO II0IO0I0Olll01OOO0lIOO01lOlIOOIIII)OF IIIOOI1II1O11lOIOlOIlOOII1010IIIII;FUNCTION IO1IllOO0II1ll1OII0OOO10OO0I1IIIII(IOOll1I1OO10IlOI0lOO1lOl1O10IOIIII:INTEGER)
RETURN III1O0Ol0IOOO0IllIOOO000O1lO0IIIII IS VARIABLE IOOIOOO1OIO1O0OIIOlOOIOlI1l1lIIIII:III1O0Ol0IOOO0IllIOOO000O1lO0IIIII:=(OTHERS=>0);VARIABLE II10110Oll1OOlIOlOlIl01111IlOIIIII:INTEGER:=0;VARIABLE IOIO00lO11l0IOO1l0I101I11l1OOIIIII:INTEGER:=0;VARIABLE
 IIIIl0I1lO1llIOIOOO1lOl11IIlOIIIII:INTEGER:=0;BEGIN IOOIOOO1OIO1O0OIIOlOOIOlI1l1lIIIII(0):=IOlIOOI0O1OIlOl01O0OIII10O11lIIIII((II1IOOO1II0l1lOl00I1O001I00O0IIIII*IO1lll0I0l0l1ll1O01Ol0III011IOIIII)REM II0l0OlOIIIO1I0IOlIIllOIOO10lIIIII);FOR II0l0O0IOlIOI00OIl0IlOlI01OI1IIIII IN 1 TO IOOll1I1OO10IlOI0lOO1lOl1O10IOIIII-1 LOOP IOOIOOO1OIO1O0OIIOlOOIOlI1l1lIIIII(II0l0O0IOlIOI00OIl0IlOlI01OI1IIIII):=1;END LOOP;FOR IIlO0l11I10OOIl000I0OOIO0IO0IIIIII IN 2 TO
 IOOll1I1OO10IlOI0lOO1lOl1O10IOIIII LOOP FOR IIOIOOI1ll1O0I1011l0O1lI0IllIOIIII IN(IIlO0l11I10OOIl000I0OOIO0IO0IIIIII-1)DOWNTO 1 LOOP II10110Oll1OOlIOlOlIl01111IlOIIIII:=IOOIOOO1OIO1O0OIIOlOOIOlI1l1lIIIII(IIOIOOI1ll1O0I1011l0O1lI0IllIOIIII);IF II10110Oll1OOlIOlOlIl01111IlOIIIII/=0 THEN IOIO00lO11l0IOO1l0I101I11l1OOIIIII:=(IOIIOIIO1lIIOOl0IlO11I00II110IIIII(II10110Oll1OOlIOlOlIl01111IlOIIIII)+(II1IOOO1II0l1lOl00I1O001I00O0IIIII+IIlO0l11I10OOIl000I0OOIO0IO0IIIIII-1)*IO1lll0I0l0l1ll1O01Ol0III011IOIIII)REM
 II0l0OlOIIIO1I0IOlIIllOIOO10lIIIII;IIIIl0I1lO1llIOIOOO1lOl11IIlOIIIII:=IOlIOOI0O1OIlOl01O0OIII10O11lIIIII(IOIO00lO11l0IOO1l0I101I11l1OOIIIII);IOOIOOO1OIO1O0OIIOlOOIOlI1l1lIIIII(IIOIOOI1ll1O0I1011l0O1lI0IllIOIIII):=II1IOO1l1I11I1ll1OI1I00lII000IIIII(IOOIOOO1OIO1O0OIIOlOOIOlI1l1lIIIII(IIOIOOI1ll1O0I1011l0O1lI0IllIOIIII-1),IIIIl0I1lO1llIOIOOO1lOl11IIlOIIIII,IO1I1l01l1OI111Ol0IO10110I11IOIIII);ELSE IOOIOOO1OIO1O0OIIOlOOIOlI1l1lIIIII(IIOIOOI1ll1O0I1011l0O1lI0IllIOIIII):=IOOIOOO1OIO1O0OIIOlOOIOlI1l1lIIIII(IIOIOOI1ll1O0I1011l0O1lI0IllIOIIII-1);END IF;END LOOP;II10110Oll1OOlIOlOlIl01111IlOIIIII:=IOOIOOO1OIO1O0OIIOlOOIOlI1l1lIIIII(0);
IOIO00lO11l0IOO1l0I101I11l1OOIIIII:=(IOIIOIIO1lIIOOl0IlO11I00II110IIIII(II10110Oll1OOlIOlOlIl01111IlOIIIII)+(II1IOOO1II0l1lOl00I1O001I00O0IIIII+IIlO0l11I10OOIl000I0OOIO0IO0IIIIII-1)*IO1lll0I0l0l1ll1O01Ol0III011IOIIII)REM II0l0OlOIIIO1I0IOlIIllOIOO10lIIIII;IOOIOOO1OIO1O0OIIOlOOIOlI1l1lIIIII(0):=IOlIOOI0O1OIlOl01O0OIII10O11lIIIII(IOIO00lO11l0IOO1l0I101I11l1OOIIIII);END LOOP;RETURN IOOIOOO1OIO1O0OIIOlOOIOlI1l1lIIIII;END;CONSTANT IOIlllIIlI1OlI0l101llI0II1O1IOIIII:III1O0Ol0IOOO0IllIOOO000O1lO0IIIII
:=IO1IllOO0II1ll1OII0OOO10OO0I1IIIII(IIIOI11O0OO00OllOllO00lOI000IOIIII);FUNCTION IOO0IO0OOOOO0I10II0llO10ll1OlIIIII(IIlIII1OIIl0OOl00I0IlOOI1IIlOIIIII:INTEGER)RETURN IIl1IIO111llI0l1O1OI00lIl1I0OIIIII IS VARIABLE IOl10OI01O100l1IIIl0IIl1lO10lIIIII:IIl1IIO111llI0l1O1OI00lIl1I0OIIIII:=(OTHERS=>(OTHERS
=>0));BEGIN FOR IOI1l0OI1IO0llll1llO11Ol1IIlIIIIII IN 0 TO IIIOI11O0OO00OllOllO00lOI000IOIIII-1 LOOP IOl10OI01O100l1IIIl0IIl1lO10lIIIII(IOI1l0OI1IO0llll1llO11Ol1IIlIIIIII):=IO1IllOO0II1ll1OII0OOO10OO0I1IIIII(IOI1l0OI1IO0llll1llO11Ol1IIlIIIIII+1);END LOOP;RETURN IOl10OI01O100l1IIIl0IIl1lO10lIIIII;END;CONSTANT IO00l1II1l000l0I11O010I1IlOlIOIIII:IIl1IIO111llI0l1O1OI00lIl1I0OIIIII:=
IOO0IO0OOOOO0I10II0llO10ll1OlIIIII(0);FUNCTION II0IO0O1III0I1I1OlI0011O001IOIIIII(IIl1OOO111O0O11l1OOllOIIIIIl0IIIII:IN INTEGER;IO00O1llIl1l1I1IIOl11OIlI1lIOOIIII:IN INTEGER)RETURN IIIOOI1II1O11lOIOlOIlOOII1010IIIII IS VARIABLE IOl1I001lIl1Il1I11lI00l11O1OOIIIII:INTEGER:=0;VARIABLE IOlO1OI10Il1OllOl1IIOOIO0I1lIIIIII:
IIIOOI1II1O11lOIOlOIlOOII1010IIIII:=(OTHERS=>'0');BEGIN IF(IIl1OOO111O0O11l1OOllOIIIIIl0IIIII=0 OR IO00O1llIl1l1I1IIOl11OIlI1lIOOIIII=0)THEN RETURN(OTHERS=>'0');END IF;IOl1I001lIl1Il1I11lI00l11O1OOIIIII:=(IOIIOIIO1lIIOOl0IlO11I00II110IIIII(IIl1OOO111O0O11l1OOllOIIIIIl0IIIII)+IOIIOIIO1lIIOOl0IlO11I00II110IIIII(IO00O1llIl1l1I1IIOl11OIlI1lIOOIIII))REM II0l0OlOIIIO1I0IOlIIllOIOO10lIIIII
;IOlO1OI10Il1OllOl1IIOOIO0I1lIIIIII:=III0OI0OlIOOl1Ol1I0l00O0lI1IIIIIII(IOlIOOI0O1OIlOl01O0OIII10O11lIIIII(IOl1I001lIl1Il1I11lI00l11O1OOIIIII),IO1I1l01l1OI111Ol0IO10110I11IOIIII);RETURN IOlO1OI10Il1OllOl1IIOOIO0I1lIIIIII;END;TYPE III0l0O0I11OOO1lI0OOIO0llOlIlIIIII IS ARRAY(0 TO II0l0OlOIIIO1I0IOlIIllOIOO10lIIIII)OF IIIOOI1II1O11lOIOlOIlOOII1010IIIII;
TYPE IOO01101I01OlOIO111IIl0OOIOI0IIIII IS ARRAY(0 TO IO1IOOl1111OI1OOII1IOl0lIIIIOIIIII-1)OF IIIOOI1II1O11lOIOlOIlOOII1010IIIII;FUNCTION II00l0IOI1lIlOlOOI0I011O1110OIIIII(IOIO1OI0IlI1I1010lO000IO01Ol0IIIII:IOOI1l1OO01O111lO010OlO1O0l0IIIIII;
IIO00Il10lI0OOllOOO0lO11lOOlIOIIII:INTEGER)RETURN III0l0O0I11OOO1lI0OOIO0llOlIlIIIII IS VARIABLE IIIIOOlIIO11011I1IlOO10OOOO0OIIIII:III0l0O0I11OOO1lI0OOIO0llOlIlIIIII:=(OTHERS=>(OTHERS=>'0'));VARIABLE IIO0101IlI11I0IOlI01l1ll0O10OIIIII
:IOO01101I01OlOIO111IIl0OOIOI0IIIII:=(OTHERS=>(OTHERS=>'0'));VARIABLE IOl00OIO0IOOllO1I1O101lIIl11OIIIII:STD_LOGIC_VECTOR(IO1I1l01l1OI111Ol0IO10110I11IOIIII-1 DOWNTO 0):=(OTHERS=>'0');VARIABLE IOl011Ol0O1Il1IIIIlIOlIl101IlIIIII:
STD_LOGIC_VECTOR(IO1I1l01l1OI111Ol0IO10110I11IOIIII-1 DOWNTO 0):=(OTHERS=>'0');VARIABLE IO00OI0ll1l1l0llI1I000OOO0010IIIII:STD_LOGIC_VECTOR(IO1I1l01l1OI111Ol0IO10110I11IOIIII-1 DOWNTO 0):=(OTHERS=>'0');VARIABLE IOl0OIIOl0O00OO0lI0I0O1IO1OOIOIIII:
INTEGER:=0;BEGIN FOR IOI0111Il0IllIIO0O0lO0I111010IIIII IN 0 TO IO1I1l01l1OI111Ol0IO10110I11IOIIII-1 LOOP IIO0101IlI11I0IOlI01l1ll0O10OIIIII(IOI0111Il0IllIIO0O0lO0I111010IIIII):=II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII(IOIO1OI0IlI1I1010lO000IO01Ol0IIIII(IOI0111Il0IllIIO0O0lO0I111010IIIII),IO1I1l01l1OI111Ol0IO10110I11IOIIII);END LOOP;FOR IOO0IOIOOll0Il0OlI001lIIIOOOIIIIII IN 0 TO(II0l0OlOIIIO1I0IOlIIllOIOO10lIIIII)
LOOP IIIIOOlIIO11011I1IlOO10OOOO0OIIIII(IOO0IOIOOll0Il0OlI001lIIIOOOIIIIII):=(OTHERS=>'0');FOR IOO0llOIlIO0110l1lOO01I00l1OIIIIII IN 0 TO IO1I1l01l1OI111Ol0IO10110I11IOIIII-1 LOOP IOl0OIIOl0O00OO0lI0I0O1IO1OOIOIIII:=2**IOO0llOIlIO0110l1lOO01I00l1OIIIIII;IOl00OIO0IOOllO1I1O101lIIl11OIIIII:=II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII(IOl0OIIOl0O00OO0lI0I0O1IO1OOIOIIII,IO1I1l01l1OI111Ol0IO10110I11IOIIII);FOR IOIO0OOIOIOl0OIllO011O11O0OOIIIIII IN 0 TO IO1I1l01l1OI111Ol0IO10110I11IOIIII-1
 LOOP IOl011Ol0O1Il1IIIIlIOlIl101IlIIIII:=II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII(IOO0IOIOOll0Il0OlI001lIIIOOOIIIIII,IO1I1l01l1OI111Ol0IO10110I11IOIIII);IO00OI0ll1l1l0llI1I000OOO0010IIIII:=II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII(2**IOIO0OOIOIOl0OIllO011O11O0OOIIIIII,IO1I1l01l1OI111Ol0IO10110I11IOIIII);IF((IOl011Ol0O1Il1IIIIlIOlIl101IlIIIII(IOIO0OOIOIOl0OIllO011O11O0OOIIIIII)AND IO00OI0ll1l1l0llI1I000OOO0010IIIII(IOIO0OOIOIOl0OIllO011O11O0OOIIIIII))='1')THEN
 IIIIOOlIIO11011I1IlOO10OOOO0OIIIII(IOO0IOIOOll0Il0OlI001lIIIOOOIIIIII):=IIIIOOlIIO11011I1IlOO10OOOO0OIIIII(IOO0IOIOOll0Il0OlI001lIIIOOOIIIIII)XOR(IIO0101IlI11I0IOlI01l1ll0O10OIIIII(IO1I1l01l1OI111Ol0IO10110I11IOIIII-1-IOIO0OOIOIOl0OIllO011O11O0OOIIIIII)AND IOl00OIO0IOOllO1I1O101lIIl11OIIIII);END IF;END LOOP;END LOOP;END LOOP;RETURN IIIIOOlIIO11011I1IlOO10OOOO0OIIIII
;END;CONSTANT IO0lI0OlO11O10O1III000O01l0l0IIIII:IOOI1l1OO01O111lO010OlO1O0l0IIIIII:=IO11OllII1lO110Ol0I0O00I01l00IIIII;CONSTANT IIO1O00llO01OII1I11lIIO001lI0IIIII:IOOI1l1OO01O111lO010OlO1O0l0IIIIII:=III01lO1l00IOOO0O0I0O0I111O0IIIIII;
CONSTANT IOIl1lI1IO111IO0OII101O1I0l0IOIIII:III0l0O0I11OOO1lI0OOIO0llOlIlIIIII:=II00l0IOI1lIlOlOOI0I011O1110OIIIII(IO0lI0OlO11O10O1III000O01l0l0IIIII,IO1IOOl1111OI1OOII1IOl0lIIIIOIIIII);CONSTANT IOOIOOOlO000O1I0lOI1OO01l0OOlIIIII:III0l0O0I11OOO1lI0OOIO0llOlIlIIIII:=II00l0IOI1lIlOlOOI0I011O1110OIIIII(
IIO1O00llO01OII1I11lIIO001lI0IIIII,IO1IOOl1111OI1OOII1IOl0lIIIIOIIIII);FUNCTION IO01O100lOO0IOOI000OO1lIOO1l0IIIII(IOl1100I00OlIllOI1I0III1O1l01IIIII:INTEGER;IO1OlIO1l10Ill0O11IO0I0ll1OlIIIIII:INTEGER)RETURN INTEGER IS VARIABLE IIOIlOO1lI01O10O1Ol0OOI10110OIIIII:INTEGER:=0;
BEGIN IIOIlOO1lI01O10O1Ol0OOI10110OIIIII:=2+IOl1100I00OlIllOI1I0III1O1l01IIIII;IF IO1OlIO1l10Ill0O11IO0I0ll1OlIIIIII=IIIOOIO01011011IOIIlllIIOO0l1IIIII THEN IIOIlOO1lI01O10O1Ol0OOI10110OIIIII:=IIOIlOO1lI01O10O1Ol0OOI10110OIIIII+2;ELSIF IO1OlIO1l10Ill0O11IO0I0ll1OlIIIIII=IO110I1O0010OIOlIO00l1IIOl0llIIIII THEN IIOIlOO1lI01O10O1Ol0OOI10110OIIIII:=IIOIlOO1lI01O10O1Ol0OOI10110OIIIII+1;END IF;RETURN
 IIOIlOO1lI01O10O1Ol0OOI10110OIIIII;END;FUNCTION IO0II1lll1llOlO1lll1001O1IlOIOIIII(IOOO00lOlO0l0llI01lIlOOIIllIlIIIII:INTEGER;IIlIIII1lOllO0IlO11I1O01110IOIIIII:INTEGER)RETURN INTEGER IS VARIABLE II0I1I1l00l1O11OOIOIIllII10IlIIIII:INTEGER:=0;
BEGIN IF IOOO00lOlO0l0llI01lIlOOIIllIlIIIII=1 AND C_SPEC=II1IOOO00I0OI0O01I000O100llOOIIIII THEN II0I1I1l00l1O11OOIOIIllII10IlIIIII:=0;ELSE IF IIlIIII1lOllO0IlO11I1O01110IOIIIII=IIIOOIO01011011IOIIlllIIOO0l1IIIII THEN II0I1I1l00l1O11OOIOIIllII10IlIIIII:=IOOO00lOlO0l0llI01lIlOOIIllIlIIIII+2;
ELSIF IIlIIII1lOllO0IlO11I1O01110IOIIIII=IO110I1O0010OIOlIO00l1IIOl0llIIIII THEN II0I1I1l00l1O11OOIOIIllII10IlIIIII:=IOOO00lOlO0l0llI01lIlOOIIllIlIIIII+1;ELSE II0I1I1l00l1O11OOIOIIllII10IlIIIII:=IOOO00lOlO0l0llI01lIlOOIIllIlIIIII;END IF;END IF;RETURN II0I1I1l00l1O11OOIOIIllII10IlIIIII;END
;CONSTANT III0lIIOOIOl0ll0ll0l1lO10IlIIIIIII:IIIOOI1II1O11lOIOlOIlOOII1010IIIII:=(OTHERS=>'1');CONSTANT III010I1Ol1OlOI0IO10O0000II11IIIII:INTEGER:=IOIlOIOl1lO1l001Ol10IO01OIlI1IIIII(
III0lIIOOIOl0ll0ll0l1lO10IlIIIIIII);SIGNAL IOIlOO00I1I00lO00l0I00OlIO01IIIIII:IIIOOI1II1O11lOIOlOIlOOII1010IIIII:=(OTHERS=>'0');SIGNAL IIO111Il00001lO0l00lOOlI1IO10IIIII:IIIOOI1II1O11lOIOlOIlOOII1010IIIII:=(OTHERS=>'0');SIGNAL II10IOlI11OOI1IO1OlI0IlI0I0I1IIIII:
IIIOOI1II1O11lOIOlOIlOOII1010IIIII:=(OTHERS=>'0');SIGNAL IO1lO1OOOl00OOI0lOI1Ol1O1lI0IIIIII:STD_LOGIC:='0';SIGNAL IO0I10OO0llIIlII1I01OOI001IIIIIIII:STD_LOGIC:='0';CONSTANT II110IlI0l101IO1IlI1O00llI00OIIIII:INTEGER:=
IO01O100lOO0IOOI000OO1lIOO1l0IIIII(C_NUM_CHANNELS,C_SPEC);CONSTANT III0O000IO1IOIO10l0I00lOIII11IIIII:INTEGER:=IO01O100lOO0IOOI000OO1lIOO1l0IIIII(C_NUM_CHANNELS,C_SPEC);CONSTANT II1llIOlOlll00O010O1lI1IOI1I1IIIII:INTEGER
:=IO01O100lOO0IOOI000OO1lIOO1l0IIIII(C_NUM_CHANNELS,C_SPEC);CONSTANT IO1I11OIllI1III1III11OlIIlIIOIIIII:INTEGER:=II110IlI0l101IO1IlI1O00llI00OIIIII-2;CONSTANT IIl11lIlOO0IIII0IOlI0l1000I1IIIIII:INTEGER:=III0O000IO1IOIO10l0I00lOIII11IIIII
-2;CONSTANT IOOI10l11llO01llIIllOI1IO0l1OIIIII:INTEGER:=II1llIOlOlll00O010O1lI1IOI1I1IIIII-2;CONSTANT IOO1IIll11IlI110IOlllI1Il1IO1IIIII:INTEGER:=IO0II1lll1llOlO1lll1001O1IlOIOIIII(C_NUM_CHANNELS,C_SPEC);
TYPE IOO000O0Ol1OlIOOI00l11I1l1I00IIIII IS ARRAY(0 TO IO1I11OIllI1III1III11OlIIlIIOIIIII)OF IIIOOI1II1O11lOIOlOIlOOII1010IIIII;SIGNAL IIll0O11l1O1lOl111IIOlOIl0I0OIIIII:IOO000O0Ol1OlIOOI00l11I1l1I00IIIII:=(OTHERS=>(OTHERS=>'0'));TYPE
 IIOI10lI0II00O0IOOl0I10001lO1IIIII IS ARRAY(0 TO IIl11lIlOO0IIII0IOlI0l1000I1IIIIII)OF STD_LOGIC;SIGNAL IIO1IIOOO0OO1100OO11l0OOllIIIOIIII:IIOI10lI0II00O0IOOl0I10001lO1IIIII:=(OTHERS=>'0');TYPE IOO01O011lIIIlOl1O0lOIOOI110IOIIII IS ARRAY
(0 TO IOOI10l11llO01llIIllOI1IO0l1OIIIII)OF STD_LOGIC;SIGNAL IOIOO101OO01Ol1101l1O01O1OOllIIIII:IOO01O011lIIIlOl1O0lOIOOI110IOIIII:=(OTHERS=>'0');SIGNAL IIOO0IIlO0O0I01l00I1011II0011IIIII:STD_LOGIC_VECTOR(IO1IOOl1111OI1OOII1IOl0lIIIIOIIIII-1
 DOWNTO 0):=(OTHERS=>'0');SIGNAL IOl0lOIIO0IllIOIO1Oll0lOOOII1IIIII:STD_LOGIC_VECTOR(IO1IOOl1111OI1OOII1IOl0lIIIIOIIIII-1 DOWNTO 0):=(OTHERS=>'0');SIGNAL IIOlI0O00IO011lIIOl100O001lIOOIIII:
STD_LOGIC_VECTOR(IO1IOOl1111OI1OOII1IOl0lIIIIOIIIII-1 DOWNTO 0):=(OTHERS=>'0');SIGNAL III0IlIOll1Ill0I0I0OlIO10I1I1IIIII:STD_LOGIC:='0';SIGNAL IOOllIl0I1ll0lII0IOIIO1lI10IIIIIII:STD_LOGIC:='0';SIGNAL
 II0I1O11OOll0l0I11O110OlI0lIOOIIII:STD_LOGIC:='1';SIGNAL II1lI1l0l00llI0l0l1O0OOII10I1IIIII:STD_LOGIC:='0';SIGNAL II0l10llII1lO0O1lOIlOOI10I0lIIIIII:STD_LOGIC:='0';SIGNAL IO1I1OlOI1OII110llI1lI0IIl0O0IIIII:STD_LOGIC:='0';SIGNAL II110IO0lllI1lOI110IO00I1lOlIIIIII:
STD_LOGIC:='0';SIGNAL IIl110lllO10l0llOI11l01I0I1OlIIIII:STD_LOGIC:='0';SIGNAL IOOll11IO1O1llOIl10010O1IIOOIIIIII:STD_LOGIC:='0';SIGNAL IIII00I101O111lII1O000IO1lOOIIIIII:STD_LOGIC:='0';SIGNAL IOOI01II11O1I1IOII1II01O1001lIIIII:
STD_LOGIC:='0';SIGNAL IO111Il1I1O0lO1OlOI0l01I1O010IIIII:STD_LOGIC_VECTOR(IO1IOOl1111OI1OOII1IOl0lIIIIOIIIII-1 DOWNTO 0):=(OTHERS=>'0');SIGNAL III011IIIl1IO1l0O11000I0llI00IIIII:STD_LOGIC:='0';
SIGNAL II1O1ll0lOO0Ol1O0OO01I0OI0lIIOIIII:STD_LOGIC:='0';SIGNAL IIO1l1Ol1l11Il0000II00lI011I0IIIII:IIlIOIlO1lO1l1I0OOOI1O1l0O0IOIIIII:=(OTHERS=>(OTHERS=>(OTHERS=>'0')));
BEGIN II0I1O11OOll0l0I11O110OlI0lIOOIIII<='1'WHEN C_HAS_CE=0 ELSE CE;II1lI1l0l00llI0l0l1O0OOII10I1IIIII<='1'WHEN C_HAS_ND=0 ELSE ND;IN_SEL:PROCESS(IIO111Il00001lO0l00lOOlI1IO10IIIII,DATA_IN)BEGIN IF IO1IIIl1OO00II0ll110l0l0IIO0lIIIII(DATA_IN
)THEN II10IOlI11OOI1IO1OlI0IlI0I0I1IIIII<=(OTHERS=>'X');ELSIF C_SPEC=IIIOOIO01011011IOIIlllIIOO0l1IIIII THEN II10IOlI11OOI1IO1OlI0IlI0I0I1IIIII<=IOOIOOOlO000O1I0lOI1OO01l0OOlIIIII(IOIlOIOl1lO1l001Ol10IO01OIlI1IIIII(DATA_IN));ELSE
 II10IOlI11OOI1IO1OlI0IlI0I0I1IIIII<=DATA_IN;END IF;END PROCESS;MAIN:PROCESS(CLK,RESET)VARIABLE IIO1OllIOO1lI1OOO1IOIII1lIl0IOIIII:INTEGER:=III010I1Ol1OlOI0IO10O0000II11IIIII;VARIABLE
 II1lI11lI1II1000lOllIOl01l0l0IIIII:IIIOOI1II1O11lOIOlOIlOOII1010IIIII:=III0lIIOOIOl0ll0ll0l1lO10IlIIIIIII;VARIABLE II0l0001lI0I0IlllI1I100OO10IIIIIII:INTEGER:=0;VARIABLE II01l0llO10l10II111lIlOIllO0lIIIII:
IOOI0OO0l1O1O000lO10OOllOIIIIOIIII:=(OTHERS=>(OTHERS=>'0'));VARIABLE IOl0I1O0OllIl0lI1IlO0OIlII0lIIIIII:INTEGER:=121;VARIABLE IIlI1l00I0IOl1l1O0llllO0I1I0IIIIII:
IIIOOI1II1O11lOIOlOIlOOII1010IIIII:=(OTHERS=>'0');VARIABLE IIl1O01ll1111l0llIOO0OOl1ll0IOIIII:STD_LOGIC:='0';VARIABLE II10l111IOllO0O1111Ill001lll1IIIII:STD_LOGIC:='0';VARIABLE IIlOI1II1OOlOl00Ol01IOl0OO0OOIIIII:STD_LOGIC:='0';
VARIABLE IIll1lO0l0lI0OII00l00OO11IlO1IIIII:STD_LOGIC:='0';VARIABLE III00O11l11IlIOI1llIIIOII100lIIIII:STD_LOGIC:='0';VARIABLE IO1l01O110OIl00l10lOOlI0lI0I0IIIII:STD_LOGIC:='0';VARIABLE IIlIO1lIl0lI1lOlI0I0O0I0OO0IIIIIII:STD_LOGIC:='0';
VARIABLE IOIIOO1001lI01IOOlOllIOOIO1O1IIIII:INTEGER:=IOO0111OO0lOOl10l1l000l0OlI0IIIIII;VARIABLE IIOlIO1l10OOO1l1IlII1ll0100IOIIIII:INTEGER:=IIlO1lIIlOlOOO0l10OI1ll0I0O10IIIII;VARIABLE III1I01Ill1l0lOIlO01lO0I1IlIIOIIII:INTEGER:=IOO0111OO0lOOl10l1l000l0OlI0IIIIII;VARIABLE IOOIl1OOO1IIl11O00lI1IlOIIl0OIIIII:STD_LOGIC:='0';VARIABLE IOlI00ll1I0I1ll0ll01l1OOl0IlIIIIII
:STD_LOGIC:='0';VARIABLE III11I01Ol11IOO00IOI1I11OOl10IIIII:STD_LOGIC:='0';VARIABLE IIl1lOIllIlIl01ll00O11OIl100IOIIII:STD_LOGIC:='0';VARIABLE IIOII0OO1Ol0lOOlO1O1OOlllIllOIIIII:STD_LOGIC:='0';VARIABLE II1011l1lI11IlIlI0l0l00100lO0IIIII
:STD_LOGIC:='0';VARIABLE IO1OO10IOIO11O10IOOOllllI1Il0IIIII:INTEGER:=IIIOI11O0OO00OllOllO00lOI000IOIIII;VARIABLE II1IOl1011OlI0O00l1O10OlllOI0IIIII:INTEGER:=IIIOI11O0OO00OllOllO00lOI000IOIIII;VARIABLE IO1OIOllI1llI01O00IIl0O111IIOOIIII:INTEGER:=IIIOI11O0OO00OllOllO00lOI000IOIIII-1;VARIABLE IO01001lO000lI1lI0IO11lO0I1OlIIIII:INTEGER:=
IIIOI11O0OO00OllOllO00lOI000IOIIII-1;PROCEDURE IOOl11OIOl101I1I1I00lIlIlO00IIIIII(IIlOOO01III1O0O0IOII0I0lOlIlOIIIII:STD_LOGIC)IS VARIABLE IIIl1IO0lOOOIIlOOllOl010IOl1IOIIII:IIIOOI1II1O11lOIOlOIlOOII1010IIIII:=(OTHERS=>'0');VARIABLE IIl010l00OlI0lO1OO11Il10lIOIOOIIII
:INTEGER:=0;VARIABLE IIOIl1I10OOOllIlIOl11lI0IO1lIOIIII:IIIOOI1II1O11lOIOlOIlOOII1010IIIII:=(OTHERS=>'0');BEGIN IF IO1l01O110OIl00l10lOOlI0lI0I0IIIII='0'THEN IF(IIlOOO01III1O0O0IOII0I0lOlIlOIIIII='0')THEN IIIl1IO0lOOOIIlOOllOl010IOl1IOIIII:=II10IOlI11OOI1IO1OlI0IlI0I0I1IIIII XOR
 IIO1l1Ol1l11Il0000II00lI011I0IIIII(II0l0001lI0I0IlllI1I100OO10IIIIIII)(IO01001lO000lI1lI0IO11lO0I1OlIIIII);ELSE IIIl1IO0lOOOIIlOOllOl010IOl1IOIIII:=II10IOlI11OOI1IO1OlI0IlI0I0I1IIIII;END IF;ELSE IIIl1IO0lOOOIIlOOllOl010IOl1IOIIII:=(OTHERS=>'0');END IF;IIl010l00OlI0lO1OO11Il10lIOIOOIIII
:=IOIlOIOl1lO1l001Ol10IO01OIlI1IIIII(IIIl1IO0lOOOIIlOOllOl010IOl1IOIIII);FOR IIl111Il0IIlOIO000I01l00l0111IIIII IN IO01001lO000lI1lI0IO11lO0I1OlIIIII DOWNTO 1 LOOP IIOIl1I10OOOllIlIOl11lI0IO1lIOIIII:=II0IO0O1III0I1I1OlI0011O001IOIIIII(IO00l1II1l000l0I11O010I1IlOlIOIIII(IO01001lO000lI1lI0IO11lO0I1OlIIIII)(IIl111Il0IIlOIO000I01l00l0111IIIII),IIl010l00OlI0lO1OO11Il10lIOIOOIIII);IF(IIlOOO01III1O0O0IOII0I0lOlIlOIIIII='0')
THEN IIO1l1Ol1l11Il0000II00lI011I0IIIII(II0l0001lI0I0IlllI1I100OO10IIIIIII)(IIl111Il0IIlOIO000I01l00l0111IIIII)<=IIO1l1Ol1l11Il0000II00lI011I0IIIII(II0l0001lI0I0IlllI1I100OO10IIIIIII)(IIl111Il0IIlOIO000I01l00l0111IIIII-1)XOR IIOIl1I10OOOllIlIOl11lI0IO1lIOIIII;ELSE IIO1l1Ol1l11Il0000II00lI011I0IIIII(
II0l0001lI0I0IlllI1I100OO10IIIIIII)(IIl111Il0IIlOIO000I01l00l0111IIIII)<=IIOIl1I10OOOllIlIOl11lI0IO1lIOIIII;END IF;END LOOP;IIOIl1I10OOOllIlIOl11lI0IO1lIOIIII:=II0IO0O1III0I1I1OlI0011O001IOIIIII(IO00l1II1l000l0I11O010I1IlOlIOIIII(IO01001lO000lI1lI0IO11lO0I1OlIIIII)(0),IIl010l00OlI0lO1OO11Il10lIOIOOIIII);IIO1l1Ol1l11Il0000II00lI011I0IIIII(II0l0001lI0I0IlllI1I100OO10IIIIIII)(0)<=
IIOIl1I10OOOllIlIOl11lI0IO1lIOIIII;END;PROCEDURE II1111O0III10O0OOlOlOO1l1I1l0IIIII(III00011101l1O1OOI0l0Il0l1l10IIIII:IN STD_LOGIC)IS BEGIN II1lI11lI1II1000lOllIOl01l0l0IIIII:=(OTHERS=>III00011101l1O1OOI0l0Il0l1l10IIIII);
II01l0llO10l10II111lIlOIllO0lIIIII:=(OTHERS=>(OTHERS=>III00011101l1O1OOI0l0Il0l1l10IIIII));IOl0I1O0OllIl0lI1IlO0OIlII0lIIIIII:=IO0lIOlI0II1000IOlOIlOI1lIlOOIIIII-IIIOI11O0OO00OllOllO00lOI000IOIIII;III00O11l11IlIOI1llIIIOII100lIIIII:=III00011101l1O1OOI0l0Il0l1l10IIIII;FOR IO0lll11llOIOOIOI1lOOIOl000I0IIIII IN 0 TO II0IO0I0Olll01OOO0lIOO01lOlIOOIIII LOOP
 FOR IO00OO00lIlIO00llOIll10l0ll1OIIIII IN 0 TO IIOIOOO11l0lO001OI10I0IIIIlIIIIIII LOOP IIO1l1Ol1l11Il0000II00lI011I0IIIII(IO0lll11llOIOOIOI1lOOIOl000I0IIIII)(IO00OO00lIlIO00llOIll10l0ll1OIIIII)<=(OTHERS=>III00011101l1O1OOI0l0Il0l1l10IIIII);END LOOP;END LOOP;IIlI1l00I0IOl1l1O0llllO0I1I0IIIIII:=(OTHERS=>III00011101l1O1OOI0l0Il0l1l10IIIII);IF
 III00011101l1O1OOI0l0Il0l1l10IIIII='1'THEN II0l0001lI0I0IlllI1I100OO10IIIIIII:=II0IO0I0Olll01OOO0lIOO01lOlIOOIIII;ELSIF III00011101l1O1OOI0l0Il0l1l10IIIII='0'THEN II0l0001lI0I0IlllI1I100OO10IIIIIII:=0;ELSE II0l0001lI0I0IlllI1I100OO10IIIIIII:=II0IO0I0Olll01OOO0lIOO01lOlIOOIIII;END IF;END;PROCEDURE
 IIO1lO000Il1O0lOII1IO0OOOIO00IIIII IS BEGIN IIO1OllIOO1lI1OOO1IOIII1lIl0IOIIII:=IOIlOIOl1lO1l001Ol10IO01OIlI1IIIII(II1lI11lI1II1000lOllIOl01l0l0IIIII)+1;II1lI11lI1II1000lOllIOl01l0l0IIIII:=
III0OI0OlIOOl1Ol1I0l00O0lI1IIIIIII(IIO1OllIOO1lI1OOO1IOIII1lIl0IOIIII,IO1IOOl1111OI1OOII1IOl0lIIIIOIIIII);END;PROCEDURE II1001l0I11O0IIOIl01I1ll0O0OlIIIII IS BEGIN IF II0l0001lI0I0IlllI1I100OO10IIIIIII<II0IO0I0Olll01OOO0lIOO01lOlIOOIIII THEN
 II0l0001lI0I0IlllI1I100OO10IIIIIII:=II0l0001lI0I0IlllI1I100OO10IIIIIII+1;ELSE II0l0001lI0I0IlllI1I100OO10IIIIIII:=0;END IF;END;PROCEDURE II1II1OO1ll10IlO0I10O0OI000IIOIIII IS BEGIN IF(C_SPEC=
IO110I1O0010OIOlIO00l1IIOl0llIIIII)THEN IF IOl0I1O0OllIl0lI1IlO0OIlII0lIIIIII>IIIOI11O0OO00OllOllO00lOI000IOIIII THEN IOl0I1O0OllIl0lI1IlO0OIlII0lIIIIII:=IOl0I1O0OllIl0lI1IlO0OIlII0lIIIIII-IIIOI11O0OO00OllOllO00lOI000IOIIII-1;ELSE IOl0I1O0OllIl0lI1IlO0OIlII0lIIIIII:=
IOl0I1O0OllIl0lI1IlO0OIlII0lIIIIII+IO0lIOlI0II1000IOlOIlOI1lIlOOIIIII-IIIOI11O0OO00OllOllO00lOI000IOIIII;END IF;END IF;END;PROCEDURE IOOl01OO110II1I0lIlI001II11I0IIIII IS BEGIN IF(C_SPEC=IO110I1O0010OIOlIO00l1IIOl0llIIIII)THEN
 II01l0llO10l10II111lIlOIllO0lIIIII(II0l0001lI0I0IlllI1I100OO10IIIIIII):=II01l0llO10l10II111lIlOIllO0lIIIII(II0l0001lI0I0IlllI1I100OO10IIIIIII)XOR II0IO0O1III0I1I1OlI0011O001IOIIIII(IOIlOIOl1lO1l001Ol10IO01OIlI1IIIII(IIlI1l00I0IOl1l1O0llllO0I1I0IIIIII),
IOlIOOI0O1OIlOl01O0OIII10O11lIIIII(IOl0I1O0OllIl0lI1IlO0OIlII0lIIIIII));END IF;END;BEGIN IOOIl1OOO1IIl11O00lI1IlOIIl0OIIIII:=II11I0011I0IIIl0100l1O01O01O0IIIII(RESET);IOlI00ll1I0I1ll0ll01l1OOl0IlIIIIII:=II11I0011I0IIIl0100l1O01O01O0IIIII(CLK);IF IOOIl1OOO1IIl11O00lI1IlOIIl0OIIIII='X'THEN
 II1111O0III10O0OOlOlOO1l1I1l0IIIII('X');IOIlOO00I1I00lO00l0I00OlIO01IIIIII<=IIlI1l00I0IOl1l1O0llllO0I1I0IIIIII;IO1lO1OOOl00OOI0lOI1Ol1O1lI0IIIIII<='X';IO1I1OlOI1OII110llI1lI0IIl0O0IIIII<='X';II110IO0lllI1lOI110IO00I1lOlIIIIII<='X';IO0I10OO0llIIlII1I01OOI001IIIIIIII<='X';ELSIF
 IOOIl1OOO1IIl11O00lI1IlOIIl0OIIIII='1'THEN II1111O0III10O0OOlOlOO1l1I1l0IIIII('0');II1lI11lI1II1000lOllIOl01l0l0IIIII:=III0OI0OlIOOl1Ol1I0l00O0lI1IIIIIII(IIOlIO1l10OOO1l1IlII1ll0100IOIIIII,IO1IOOl1111OI1OOII1IOl0lIIIIOIIIII);II0l0001lI0I0IlllI1I100OO10IIIIIII:=0;
IOIlOO00I1I00lO00l0I00OlIO01IIIIII<=IIlI1l00I0IOl1l1O0llllO0I1I0IIIIII;IO1lO1OOOl00OOI0lOI1Ol1O1lI0IIIIII<='1';IO1I1OlOI1OII110llI1lI0IIl0O0IIIII<='1';II110IO0lllI1lOI110IO00I1lOlIIIIII<='1';IO0I10OO0llIIlII1I01OOI001IIIIIIII<='0';ELSIF(CLK'EVENT AND IOlI00ll1I0I1ll0ll01l1OOl0IlIIIIII='1'AND II11I0011I0IIIl0100l1O01O01O0IIIII(CLK'LAST_VALUE
)='0')THEN III11I01Ol11IOO00IOI1I11OOl10IIIII:=II11I0011I0IIIl0100l1O01O01O0IIIII(II0I1O11OOll0l0I11O110OlI0lIOOIIII);IF III11I01Ol11IOO00IOI1I11OOl10IIIII='1'THEN IIOII0OO1Ol0lOOlO1O1OOlllIllOIIIII:=II11I0011I0IIIl0100l1O01O01O0IIIII(BYPASS);IF IIOII0OO1Ol0lOOlO1O1OOlllIllOIIIII='0'THEN IIl1lOIllIlIl01ll00O11OIl100IOIIII:=II11I0011I0IIIl0100l1O01O01O0IIIII(II1lI1l0l00llI0l0l1O0OOII10I1IIIII);II1011l1lI11IlIlI0l0l00100lO0IIIII:=II11I0011I0IIIl0100l1O01O01O0IIIII(
START);IF IIl1lOIllIlIl01ll00O11OIl100IOIIII='1'THEN IF II1011l1lI11IlIlI0l0l00100lO0IIIII='0'THEN IF(IO1IIIl1OO00II0ll110l0l0IIO0lIIIII(II1lI11lI1II1000lOllIOl01l0l0IIIII))THEN II1111O0III10O0OOlOlOO1l1I1l0IIIII('X');IIlI1l00I0IOl1l1O0llllO0I1I0IIIIII:=(OTHERS=>'X');
IIl1O01ll1111l0llIOO0OOl1ll0IOIIII:='X';II10l111IOllO0O1111Ill001lll1IIIII:='X';IIlOI1II1OOlOl00Ol01IOl0OO0OOIIIII:='X';IIll1lO0l0lI0OII00l00OO11IlO1IIIII:='X';ELSIF IOIlOIOl1lO1l001Ol10IO01OIlI1IIIII(II1lI11lI1II1000lOllIOl01l0l0IIIII)<III1I01Ill1l0lOIlO01lO0I1IlIIOIIII-1 AND III00O11l11IlIOI1llIIIOII100lIIIII=
'1'THEN IOOl11OIOl101I1I1I00lIlIlO00IIIIII(II1011l1lI11IlIlI0l0l00100lO0IIIII);IIlI1l00I0IOl1l1O0llllO0I1I0IIIIII:=II10IOlI11OOI1IO1OlI0IlI0I0I1IIIII;IOOl01OO110II1I0lIlI001II11I0IIIII;IIl1O01ll1111l0llIOO0OOl1ll0IOIIII:='1';II10l111IOllO0O1111Ill001lll1IIIII:='1';
IIlOI1II1OOlOl00Ol01IOl0OO0OOIIIII:='0';IIll1lO0l0lI0OII00l00OO11IlO1IIIII:='1';IF(II0l0001lI0I0IlllI1I100OO10IIIIIII=II0IO0I0Olll01OOO0lIOO01lOlIOOIIII)THEN IIO1lO000Il1O0lOII1IO0OOOIO00IIIII;II1II1OO1ll10IlO0I10O0OI000IIOIIII;END IF;
II1001l0I11O0IIOIl01I1ll0O0OlIIIII;ELSIF IOIlOIOl1lO1l001Ol10IO01OIlI1IIIII(II1lI11lI1II1000lOllIOl01l0l0IIIII)=III1I01Ill1l0lOIlO01lO0I1IlIIOIIII-1 AND III00O11l11IlIOI1llIIIOII100lIIIII='1'THEN
 IOOl11OIOl101I1I1I00lIlIlO00IIIIII(II1011l1lI11IlIlI0l0l00100lO0IIIII);IIlI1l00I0IOl1l1O0llllO0I1I0IIIIII:=II10IOlI11OOI1IO1OlI0IlI0I0I1IIIII;IOOl01OO110II1I0lIlI001II11I0IIIII;IIl1O01ll1111l0llIOO0OOl1ll0IOIIII:='1';II10l111IOllO0O1111Ill001lll1IIIII:='1';
IIlOI1II1OOlOl00Ol01IOl0OO0OOIIIII:='0';IIll1lO0l0lI0OII00l00OO11IlO1IIIII:='1';IF(II0l0001lI0I0IlllI1I100OO10IIIIIII=II0IO0I0Olll01OOO0lIOO01lOlIOOIIII)THEN IIO1lO000Il1O0lOII1IO0OOOIO00IIIII;II1II1OO1ll10IlO0I10O0OI000IIOIIII;II10l111IOllO0O1111Ill001lll1IIIII:='0';END IF
;II1001l0I11O0IIOIl01I1ll0O0OlIIIII;ELSIF IOIlOIOl1lO1l001Ol10IO01OIlI1IIIII(II1lI11lI1II1000lOllIOl01l0l0IIIII)<IIOlIO1l10OOO1l1IlII1ll0100IOIIIII-1 AND III00O11l11IlIOI1llIIIOII100lIIIII='1'THEN IO1l01O110OIl00l10lOOlI0lI0I0IIIII:='1';
IOOl11OIOl101I1I1I00lIlIlO00IIIIII(II1011l1lI11IlIlI0l0l00100lO0IIIII);IIlI1l00I0IOl1l1O0llllO0I1I0IIIIII:=IIO1l1Ol1l11Il0000II00lI011I0IIIII(II0l0001lI0I0IlllI1I100OO10IIIIIII)(IO01001lO000lI1lI0IO11lO0I1OlIIIII);IOOl01OO110II1I0lIlI001II11I0IIIII;
IIl1O01ll1111l0llIOO0OOl1ll0IOIIII:='0';IIll1lO0l0lI0OII00l00OO11IlO1IIIII:='1';IF(II0l0001lI0I0IlllI1I100OO10IIIIIII=II0IO0I0Olll01OOO0lIOO01lOlIOOIIII)THEN IIO1lO000Il1O0lOII1IO0OOOIO00IIIII;II1II1OO1ll10IlO0I10O0OI000IIOIIII;END IF;
II1001l0I11O0IIOIl01I1ll0O0OlIIIII;ELSIF IOIlOIOl1lO1l001Ol10IO01OIlI1IIIII(II1lI11lI1II1000lOllIOl01l0l0IIIII)=IIOlIO1l10OOO1l1IlII1ll0100IOIIIII-1 AND III00O11l11IlIOI1llIIIOII100lIIIII='1'THEN IO1l01O110OIl00l10lOOlI0lI0I0IIIII:='1';
IOOl11OIOl101I1I1I00lIlIlO00IIIIII(II1011l1lI11IlIlI0l0l00100lO0IIIII);IIlI1l00I0IOl1l1O0llllO0I1I0IIIIII:=IIO1l1Ol1l11Il0000II00lI011I0IIIII(II0l0001lI0I0IlllI1I100OO10IIIIIII)(IO01001lO000lI1lI0IO11lO0I1OlIIIII);IOOl01OO110II1I0lIlI001II11I0IIIII;
IIl1O01ll1111l0llIOO0OOl1ll0IOIIII:='0';II10l111IOllO0O1111Ill001lll1IIIII:='0';IIlOI1II1OOlOl00Ol01IOl0OO0OOIIIII:='0';IIll1lO0l0lI0OII00l00OO11IlO1IIIII:='1';IF(II0l0001lI0I0IlllI1I100OO10IIIIIII=II0IO0I0Olll01OOO0lIOO01lOlIOOIIII)THEN IIO1lO000Il1O0lOII1IO0OOOIO00IIIII;
II1II1OO1ll10IlO0I10O0OI000IIOIIII;IF(C_SPEC/=IO110I1O0010OIOlIO00l1IIOl0llIIIII)THEN II10l111IOllO0O1111Ill001lll1IIIII:='1';IIlOI1II1OOlOl00Ol01IOl0OO0OOIIIII:='1';III00O11l11IlIOI1llIIIOII100lIIIII:='0';END IF;END IF;
II1001l0I11O0IIOIl01I1ll0O0OlIIIII;ELSIF IOIlOIOl1lO1l001Ol10IO01OIlI1IIIII(II1lI11lI1II1000lOllIOl01l0l0IIIII)=IIOlIO1l10OOO1l1IlII1ll0100IOIIIII AND(C_SPEC=IO110I1O0010OIOlIO00l1IIOl0llIIIII)AND III00O11l11IlIOI1llIIIOII100lIIIII='1'THEN IO1l01O110OIl00l10lOOlI0lI0I0IIIII:='1';
IIlI1l00I0IOl1l1O0llllO0I1I0IIIIII:=II01l0llO10l10II111lIlOIllO0lIIIII(II0l0001lI0I0IlllI1I100OO10IIIIIII);IIl1O01ll1111l0llIOO0OOl1ll0IOIIII:='0';IIll1lO0l0lI0OII00l00OO11IlO1IIIII:='1';II10l111IOllO0O1111Ill001lll1IIIII:='0';IIlOI1II1OOlOl00Ol01IOl0OO0OOIIIII:='0';IF(II0l0001lI0I0IlllI1I100OO10IIIIIII=II0IO0I0Olll01OOO0lIOO01lOlIOOIIII)
THEN IIO1lO000Il1O0lOII1IO0OOOIO00IIIII;II10l111IOllO0O1111Ill001lll1IIIII:='1';IIlOI1II1OOlOl00Ol01IOl0OO0OOIIIII:='1';III00O11l11IlIOI1llIIIOII100lIIIII:='0';END IF;II1001l0I11O0IIOIl01I1ll0O0OlIIIII;ELSE IO1l01O110OIl00l10lOOlI0lI0I0IIIII:='0';IIlI1l00I0IOl1l1O0llllO0I1I0IIIIII:=
II10IOlI11OOI1IO1OlI0IlI0I0I1IIIII;IIl1O01ll1111l0llIOO0OOl1ll0IOIIII:='1';II10l111IOllO0O1111Ill001lll1IIIII:='1';IIlOI1II1OOlOl00Ol01IOl0OO0OOIIIII:='1';IIll1lO0l0lI0OII00l00OO11IlO1IIIII:='0';III00O11l11IlIOI1llIIIOII100lIIIII:='0';END IF;ELSIF II1011l1lI11IlIlI0l0l00100lO0IIIII='1'THEN
 II1111O0III10O0OOlOlOO1l1I1l0IIIII('0');III00O11l11IlIOI1llIIIOII100lIIIII:='1';IO1l01O110OIl00l10lOOlI0lI0I0IIIII:='0';IF(C_HAS_N_IN=0)THEN IIOlIO1l10OOO1l1IlII1ll0100IOIIIII:=IIlO1lIIlOlOOO0l10OI1ll0I0O10IIIII;IOIIOO1001lI01IOOlOllIOOIO1O1IIIII:=IOO0111OO0lOOl10l1l000l0OlI0IIIIII;ELSIF(IO1IIIl1OO00II0ll110l0l0IIO0lIIIII(N_IN))THEN
 II1111O0III10O0OOlOlOO1l1I1l0IIIII('X');ELSE IIOlIO1l10OOO1l1IlII1ll0100IOIIIII:=IOIlOIOl1lO1l001Ol10IO01OIlI1IIIII(N_IN);IF(C_HAS_R_IN=0)THEN IOIIOO1001lI01IOOlOllIOOIO1O1IIIII:=IIOlIO1l10OOO1l1IlII1ll0100IOIIIII-IIIOI11O0OO00OllOllO00lOI000IOIIII;II1IOl1011OlI0O00l1O10OlllOI0IIIII:=IIIOI11O0OO00OllOllO00lOI000IOIIII;
IO01001lO000lI1lI0IO11lO0I1OlIIIII:=IIIOI11O0OO00OllOllO00lOI000IOIIII-1;III1I01Ill1l0lOIlO01lO0I1IlIIOIIII:=IIOlIO1l10OOO1l1IlII1ll0100IOIIIII-II1IOl1011OlI0O00l1O10OlllOI0IIIII;ELSIF(IO1IIIl1OO00II0ll110l0l0IIO0lIIIII(N_IN))THEN II1111O0III10O0OOlOlOO1l1I1l0IIIII('X');ELSE IOIIOO1001lI01IOOlOllIOOIO1O1IIIII:=IIOlIO1l10OOO1l1IlII1ll0100IOIIIII-IIIOI11O0OO00OllOllO00lOI000IOIIII;II1IOl1011OlI0O00l1O10OlllOI0IIIII:=
IOIlOIOl1lO1l001Ol10IO01OIlI1IIIII(R_IN);IO01001lO000lI1lI0IO11lO0I1OlIIIII:=II1IOl1011OlI0O00l1O10OlllOI0IIIII-1;III1I01Ill1l0lOIlO01lO0I1IlIIOIIII:=IIOlIO1l10OOO1l1IlII1ll0100IOIIIII-II1IOl1011OlI0O00l1O10OlllOI0IIIII;END IF;END IF;IOOl11OIOl101I1I1I00lIlIlO00IIIIII(II1011l1lI11IlIlI0l0l00100lO0IIIII);
IIlI1l00I0IOl1l1O0llllO0I1I0IIIIII:=II10IOlI11OOI1IO1OlI0IlI0I0I1IIIII;IOOl01OO110II1I0lIlI001II11I0IIIII;IIl1O01ll1111l0llIOO0OOl1ll0IOIIII:='1';II10l111IOllO0O1111Ill001lll1IIIII:='1';IIlOI1II1OOlOl00Ol01IOl0OO0OOIIIII:='0';IIll1lO0l0lI0OII00l00OO11IlO1IIIII:='1';IF(II0l0001lI0I0IlllI1I100OO10IIIIIII=II0IO0I0Olll01OOO0lIOO01lOlIOOIIII
)THEN IIO1lO000Il1O0lOII1IO0OOOIO00IIIII;II1II1OO1ll10IlO0I10O0OI000IIOIIII;END IF;II1001l0I11O0IIOIl01I1ll0O0OlIIIII;ELSE II1111O0III10O0OOlOlOO1l1I1l0IIIII('X');
IIlI1l00I0IOl1l1O0llllO0I1I0IIIIII:=(OTHERS=>'X');IIl1O01ll1111l0llIOO0OOl1ll0IOIIII:='X';II10l111IOllO0O1111Ill001lll1IIIII:='X';IIlOI1II1OOlOl00Ol01IOl0OO0OOIIIII:='X';IIll1lO0l0lI0OII00l00OO11IlO1IIIII:='X';END IF;ELSIF IIl1lOIllIlIl01ll00O11OIl100IOIIII='0'THEN IF(IO1IIIl1OO00II0ll110l0l0IIO0lIIIII(II1lI11lI1II1000lOllIOl01l0l0IIIII
))THEN II1111O0III10O0OOlOlOO1l1I1l0IIIII('X');IIlI1l00I0IOl1l1O0llllO0I1I0IIIIII:=(OTHERS=>'X');IIl1O01ll1111l0llIOO0OOl1ll0IOIIII:='X';II10l111IOllO0O1111Ill001lll1IIIII:='X';IIlOI1II1OOlOl00Ol01IOl0OO0OOIIIII:='X';IIll1lO0l0lI0OII00l00OO11IlO1IIIII:='X';ELSIF
 IOIlOIOl1lO1l001Ol10IO01OIlI1IIIII(II1lI11lI1II1000lOllIOl01l0l0IIIII)<III1I01Ill1l0lOIlO01lO0I1IlIIOIIII-1 AND III00O11l11IlIOI1llIIIOII100lIIIII='1'THEN IIlI1l00I0IOl1l1O0llllO0I1I0IIIIII:=II10IOlI11OOI1IO1OlI0IlI0I0I1IIIII;IIl1O01ll1111l0llIOO0OOl1ll0IOIIII:='1';IIll1lO0l0lI0OII00l00OO11IlO1IIIII:='0';
II10l111IOllO0O1111Ill001lll1IIIII:='1';IIlOI1II1OOlOl00Ol01IOl0OO0OOIIIII:='0';ELSIF IOIlOIOl1lO1l001Ol10IO01OIlI1IIIII(II1lI11lI1II1000lOllIOl01l0l0IIIII)=III1I01Ill1l0lOIlO01lO0I1IlIIOIIII-1 AND III00O11l11IlIOI1llIIIOII100lIIIII='1'THEN IIlI1l00I0IOl1l1O0llllO0I1I0IIIIII:=II10IOlI11OOI1IO1OlI0IlI0I0I1IIIII
;IIl1O01ll1111l0llIOO0OOl1ll0IOIIII:='1';IIll1lO0l0lI0OII00l00OO11IlO1IIIII:='0';II10l111IOllO0O1111Ill001lll1IIIII:='1';IIlOI1II1OOlOl00Ol01IOl0OO0OOIIIII:='0';ELSIF IOIlOIOl1lO1l001Ol10IO01OIlI1IIIII(II1lI11lI1II1000lOllIOl01l0l0IIIII)<IIOlIO1l10OOO1l1IlII1ll0100IOIIIII-1 AND III00O11l11IlIOI1llIIIOII100lIIIII='1'
THEN IO1l01O110OIl00l10lOOlI0lI0I0IIIII:='1';IOOl11OIOl101I1I1I00lIlIlO00IIIIII(II1011l1lI11IlIlI0l0l00100lO0IIIII AND IIl1lOIllIlIl01ll00O11OIl100IOIIII);IIlI1l00I0IOl1l1O0llllO0I1I0IIIIII:=IIO1l1Ol1l11Il0000II00lI011I0IIIII(II0l0001lI0I0IlllI1I100OO10IIIIIII)(IO01001lO000lI1lI0IO11lO0I1OlIIIII);
IOOl01OO110II1I0lIlI001II11I0IIIII;IIl1O01ll1111l0llIOO0OOl1ll0IOIIII:='0';II10l111IOllO0O1111Ill001lll1IIIII:='0';IIlOI1II1OOlOl00Ol01IOl0OO0OOIIIII:='0';IIll1lO0l0lI0OII00l00OO11IlO1IIIII:='1';IF(II0l0001lI0I0IlllI1I100OO10IIIIIII=II0IO0I0Olll01OOO0lIOO01lOlIOOIIII)THEN
 IIO1lO000Il1O0lOII1IO0OOOIO00IIIII;II1II1OO1ll10IlO0I10O0OI000IIOIIII;END IF;II1001l0I11O0IIOIl01I1ll0O0OlIIIII;ELSIF IOIlOIOl1lO1l001Ol10IO01OIlI1IIIII(
II1lI11lI1II1000lOllIOl01l0l0IIIII)=IIOlIO1l10OOO1l1IlII1ll0100IOIIIII-1 AND III00O11l11IlIOI1llIIIOII100lIIIII='1'THEN IO1l01O110OIl00l10lOOlI0lI0I0IIIII:='1';IOOl11OIOl101I1I1I00lIlIlO00IIIIII(II1011l1lI11IlIlI0l0l00100lO0IIIII AND IIl1lOIllIlIl01ll00O11OIl100IOIIII);IIlI1l00I0IOl1l1O0llllO0I1I0IIIIII:=
IIO1l1Ol1l11Il0000II00lI011I0IIIII(II0l0001lI0I0IlllI1I100OO10IIIIIII)(IO01001lO000lI1lI0IO11lO0I1OlIIIII);IOOl01OO110II1I0lIlI001II11I0IIIII;IIl1O01ll1111l0llIOO0OOl1ll0IOIIII:='0';II10l111IOllO0O1111Ill001lll1IIIII:='0';IIlOI1II1OOlOl00Ol01IOl0OO0OOIIIII:='0';IIll1lO0l0lI0OII00l00OO11IlO1IIIII:=
'1';IF(II0l0001lI0I0IlllI1I100OO10IIIIIII=II0IO0I0Olll01OOO0lIOO01lOlIOOIIII)THEN IIO1lO000Il1O0lOII1IO0OOOIO00IIIII;II1II1OO1ll10IlO0I10O0OI000IIOIIII;IF(C_SPEC/=IO110I1O0010OIOlIO00l1IIOl0llIIIII)THEN II10l111IOllO0O1111Ill001lll1IIIII:='1';
IIlOI1II1OOlOl00Ol01IOl0OO0OOIIIII:='1';III00O11l11IlIOI1llIIIOII100lIIIII:='0';END IF;END IF;II1001l0I11O0IIOIl01I1ll0O0OlIIIII;ELSIF IOIlOIOl1lO1l001Ol10IO01OIlI1IIIII(II1lI11lI1II1000lOllIOl01l0l0IIIII)=IIOlIO1l10OOO1l1IlII1ll0100IOIIIII AND(C_SPEC=
IO110I1O0010OIOlIO00l1IIOl0llIIIII)AND III00O11l11IlIOI1llIIIOII100lIIIII='1'THEN IO1l01O110OIl00l10lOOlI0lI0I0IIIII:='1';IIlI1l00I0IOl1l1O0llllO0I1I0IIIIII:=II01l0llO10l10II111lIlOIllO0lIIIII(II0l0001lI0I0IlllI1I100OO10IIIIIII);IIl1O01ll1111l0llIOO0OOl1ll0IOIIII:='0';IIll1lO0l0lI0OII00l00OO11IlO1IIIII:='1';II10l111IOllO0O1111Ill001lll1IIIII:=
'0';IIlOI1II1OOlOl00Ol01IOl0OO0OOIIIII:='0';IF(II0l0001lI0I0IlllI1I100OO10IIIIIII=II0IO0I0Olll01OOO0lIOO01lOlIOOIIII)THEN IIO1lO000Il1O0lOII1IO0OOOIO00IIIII;II10l111IOllO0O1111Ill001lll1IIIII:='1';IIlOI1II1OOlOl00Ol01IOl0OO0OOIIIII:='1';III00O11l11IlIOI1llIIIOII100lIIIII:='0';END IF;
II1001l0I11O0IIOIl01I1ll0O0OlIIIII;ELSE IO1l01O110OIl00l10lOOlI0lI0I0IIIII:='0';IIlI1l00I0IOl1l1O0llllO0I1I0IIIIII:=II10IOlI11OOI1IO1OlI0IlI0I0I1IIIII;IIl1O01ll1111l0llIOO0OOl1ll0IOIIII:='1';II10l111IOllO0O1111Ill001lll1IIIII:='1';IIlOI1II1OOlOl00Ol01IOl0OO0OOIIIII:='1';IIll1lO0l0lI0OII00l00OO11IlO1IIIII:='0';III00O11l11IlIOI1llIIIOII100lIIIII:=
'0';END IF;ELSE II1111O0III10O0OOlOlOO1l1I1l0IIIII('X');IIlI1l00I0IOl1l1O0llllO0I1I0IIIIII:=(OTHERS=>'X');IIl1O01ll1111l0llIOO0OOl1ll0IOIIII:='X';II10l111IOllO0O1111Ill001lll1IIIII:='X';IIlOI1II1OOlOl00Ol01IOl0OO0OOIIIII:='X';IIll1lO0l0lI0OII00l00OO11IlO1IIIII:='X';
END IF;ELSIF IIOII0OO1Ol0lOOlO1O1OOlllIllOIIIII='1'THEN IIlI1l00I0IOl1l1O0llllO0I1I0IIIIII:=II10IOlI11OOI1IO1OlI0IlI0I0I1IIIII;IIl1O01ll1111l0llIOO0OOl1ll0IOIIII:='1';IIll1lO0l0lI0OII00l00OO11IlO1IIIII:='0';IF(IO1IIIl1OO00II0ll110l0l0IIO0lIIIII(II1lI11lI1II1000lOllIOl01l0l0IIIII))THEN II10l111IOllO0O1111Ill001lll1IIIII:='X';
IIlOI1II1OOlOl00Ol01IOl0OO0OOIIIII:='X';ELSIF IOIlOIOl1lO1l001Ol10IO01OIlI1IIIII(II1lI11lI1II1000lOllIOl01l0l0IIIII)<III1I01Ill1l0lOIlO01lO0I1IlIIOIIII AND III00O11l11IlIOI1llIIIOII100lIIIII='1'THEN II10l111IOllO0O1111Ill001lll1IIIII:='1';IIlOI1II1OOlOl00Ol01IOl0OO0OOIIIII:='0';ELSIF
 IOIlOIOl1lO1l001Ol10IO01OIlI1IIIII(II1lI11lI1II1000lOllIOl01l0l0IIIII)<IIOlIO1l10OOO1l1IlII1ll0100IOIIIII AND III00O11l11IlIOI1llIIIOII100lIIIII='1'THEN II10l111IOllO0O1111Ill001lll1IIIII:='0';IIlOI1II1OOlOl00Ol01IOl0OO0OOIIIII:='0';ELSIF IOIlOIOl1lO1l001Ol10IO01OIlI1IIIII
(II1lI11lI1II1000lOllIOl01l0l0IIIII)=IIOlIO1l10OOO1l1IlII1ll0100IOIIIII AND III00O11l11IlIOI1llIIIOII100lIIIII='1'AND(C_SPEC=IO110I1O0010OIOlIO00l1IIOl0llIIIII)THEN II10l111IOllO0O1111Ill001lll1IIIII:='0';IIlOI1II1OOlOl00Ol01IOl0OO0OOIIIII:='0';ELSE II10l111IOllO0O1111Ill001lll1IIIII:='1';IIlOI1II1OOlOl00Ol01IOl0OO0OOIIIII:='1';END IF
;ELSE II1111O0III10O0OOlOlOO1l1I1l0IIIII('X');IIlI1l00I0IOl1l1O0llllO0I1I0IIIIII:=(OTHERS=>'X');IIl1O01ll1111l0llIOO0OOl1ll0IOIIII:='X';II10l111IOllO0O1111Ill001lll1IIIII:='X';IIlOI1II1OOlOl00Ol01IOl0OO0OOIIIII:='X';IIll1lO0l0lI0OII00l00OO11IlO1IIIII:='X';END IF;
IOIlOO00I1I00lO00l0I00OlIO01IIIIII<=IIlI1l00I0IOl1l1O0llllO0I1I0IIIIII;IO1lO1OOOl00OOI0lOI1Ol1O1lI0IIIIII<=IIl1O01ll1111l0llIOO0OOl1ll0IOIIII;IO1I1OlOI1OII110llI1lI0IIl0O0IIIII<=II10l111IOllO0O1111Ill001lll1IIIII;II110IO0lllI1lOI110IO00I1lOlIIIIII<=IIlOI1II1OOlOl00Ol01IOl0OO0OOIIIII;IO0I10OO0llIIlII1I01OOI001IIIIIIII<=IIll1lO0l0lI0OII00l00OO11IlO1IIIII;ELSIF III11I01Ol11IOO00IOI1I11OOl10IIIII='X'THEN
 II1111O0III10O0OOlOlOO1l1I1l0IIIII('X');IOIlOO00I1I00lO00l0I00OlIO01IIIIII<=IIlI1l00I0IOl1l1O0llllO0I1I0IIIIII;IO1lO1OOOl00OOI0lOI1Ol1O1lI0IIIIII<='X';IO1I1OlOI1OII110llI1lI0IIl0O0IIIII<='X';II110IO0lllI1lOI110IO00I1lOlIIIIII<='X';IO0I10OO0llIIlII1I01OOI001IIIIIIII<='X';END IF;ELSIF
(CLK'EVENT AND IOlI00ll1I0I1ll0ll01l1OOl0IlIIIIII='X')THEN II1111O0III10O0OOlOlOO1l1I1l0IIIII('X');IOIlOO00I1I00lO00l0I00OlIO01IIIIII<=IIlI1l00I0IOl1l1O0llllO0I1I0IIIIII;IO1lO1OOOl00OOI0lOI1Ol1O1lI0IIIIII<='X';IO1I1OlOI1OII110llI1lI0IIl0O0IIIII<='X';II110IO0lllI1lOI110IO00I1lOlIIIIII<='X'
;IO0I10OO0llIIlII1I01OOI001IIIIIIII<='X';END IF;END PROCESS;SIGNAL_LATENCY:PROCESS(CLK,RESET)VARIABLE II0IIlIOII0IIl1lIO1llO1O1lOlIIIIII:STD_LOGIC:='0';VARIABLE IIll0I0ll1ll1O0IOlO1O01llII00IIIII:STD_LOGIC
:='0';VARIABLE II1ll1Il1Il11O10OllIl0l1l1l0IOIIII:STD_LOGIC:='0';VARIABLE III0II00l1IIlIO100l00OlI1l1O0IIIII:STD_LOGIC:='0';VARIABLE II11OIIIO0I0OI0IIIIO1lOO011IlIIIII:STD_LOGIC:='0';BEGIN II0IIlIOII0IIl1lIO1llO1O1lOlIIIIII:=II11I0011I0IIIl0100l1O01O01O0IIIII(RESET
);IF II0IIlIOII0IIl1lIO1llO1O1lOlIIIIII='X'THEN IIOO0IIlO0O0I01l00I1011II0011IIIII<=(OTHERS=>'X');III0IlIOll1Ill0I0I0OlIO10I1I1IIIII<='X';II0l10llII1lO0O1lOIlOOI10I0lIIIIII<='X';IIll0O11l1O1lOl111IIOlOIl0I0OIIIII<=(OTHERS=>(OTHERS=>'X'));IIO1IIOOO0OO1100OO11l0OOllIIIOIIII<=(OTHERS
=>'X');IOIOO101OO01Ol1101l1O01O1OOllIIIII<=(OTHERS=>'X');ELSIF II11I0011I0IIIl0100l1O01O01O0IIIII(RESET)='1'THEN IIOO0IIlO0O0I01l00I1011II0011IIIII<=(OTHERS=>'0');III0IlIOll1Ill0I0I0OlIO10I1I1IIIII<='1';II0l10llII1lO0O1lOIlOOI10I0lIIIIII<='0';IIll0O11l1O1lOl111IIOlOIl0I0OIIIII<=(OTHERS=>(
OTHERS=>'0'));IIO1IIOOO0OO1100OO11l0OOllIIIOIIII<=(OTHERS=>'1');IOIOO101OO01Ol1101l1O01O1OOllIIIII<=(OTHERS=>'0');ELSIF(CLK'EVENT AND II11I0011I0IIIl0100l1O01O01O0IIIII(CLK)='1'AND II11I0011I0IIIl0100l1O01O01O0IIIII(CLK'LAST_VALUE)='0')THEN
 II1ll1Il1Il11O10OllIl0l1l1l0IOIIII:=II11I0011I0IIIl0100l1O01O01O0IIIII(II0I1O11OOll0l0I11O110OlI0lIOOIIII);IF II1ll1Il1Il11O10OllIl0l1l1l0IOIIII='1'THEN IIll0O11l1O1lOl111IIOlOIl0I0OIIIII(0)<=IOIlOO00I1I00lO00l0I00OlIO01IIIIII;IIO1IIOOO0OO1100OO11l0OOllIIIOIIII(0)<=IO1lO1OOOl00OOI0lOI1Ol1O1lI0IIIIII;IOIOO101OO01Ol1101l1O01O1OOllIIIII(0)<=IO0I10OO0llIIlII1I01OOI001IIIIIIII;IF(
IO1I11OIllI1III1III11OlIIlIIOIIIII>0)THEN FOR IOl0lI0l0O1IlOIlI1IlO1l01Il00IIIII IN IO1I11OIllI1III1III11OlIIlIIOIIIII DOWNTO 1 LOOP IIll0O11l1O1lOl111IIOlOIl0I0OIIIII(IOl0lI0l0O1IlOIlI1IlO1l01Il00IIIII)<=IIll0O11l1O1lOl111IIOlOIl0I0OIIIII(IOl0lI0l0O1IlOIlI1IlO1l01Il00IIIII-1);END LOOP;END IF;IF(IIl11lIlOO0IIII0IOlI0l1000I1IIIIII>0)THEN
 FOR III101l00lllOOOlIO0OO1lI1OO1OIIIII IN IIl11lIlOO0IIII0IOlI0l1000I1IIIIII DOWNTO 1 LOOP IIO1IIOOO0OO1100OO11l0OOllIIIOIIII(III101l00lllOOOlIO0OO1lI1OO1OIIIII)<=IIO1IIOOO0OO1100OO11l0OOllIIIOIIII(III101l00lllOOOlIO0OO1lI1OO1OIIIII-1);END LOOP;END IF;IF(IOOI10l11llO01llIIllOI1IO0l1OIIIII>=1)THEN FOR II0l0l0II0Il010II1l000011O1lIIIIII IN
 IOOI10l11llO01llIIllOI1IO0l1OIIIII DOWNTO 1 LOOP IOIOO101OO01Ol1101l1O01O1OOllIIIII(II0l0l0II0Il010II1l000011O1lIIIIII)<=IOIOO101OO01Ol1101l1O01O1OOllIIIII(II0l0l0II0Il010II1l000011O1lIIIIII-1);END LOOP;END IF;IIOO0IIlO0O0I01l00I1011II0011IIIII<=IIll0O11l1O1lOl111IIOlOIl0I0OIIIII(IO1I11OIllI1III1III11OlIIlIIOIIIII-1);III0IlIOll1Ill0I0I0OlIO10I1I1IIIII<=
IIO1IIOOO0OO1100OO11l0OOllIIIOIIII(IIl11lIlOO0IIII0IOlI0l1000I1IIIIII-1);II0l10llII1lO0O1lOIlOOI10I0lIIIIII<=IOIOO101OO01Ol1101l1O01O1OOllIIIII(IOOI10l11llO01llIIllOI1IO0l1OIIIII-1);ELSIF II1ll1Il1Il11O10OllIl0l1l1l0IOIIII='X'THEN IIOO0IIlO0O0I01l00I1011II0011IIIII<=(OTHERS=>'X');III0IlIOll1Ill0I0I0OlIO10I1I1IIIII<='X';
II0l10llII1lO0O1lOIlOOI10I0lIIIIII<='X';IIll0O11l1O1lOl111IIOlOIl0I0OIIIII<=(OTHERS=>(OTHERS=>'X'));IIO1IIOOO0OO1100OO11l0OOllIIIOIIII<=(OTHERS=>'X');IOIOO101OO01Ol1101l1O01O1OOllIIIII<=(OTHERS=>'X');END IF;ELSIF(CLK'EVENT AND II11I0011I0IIIl0100l1O01O01O0IIIII(CLK
)='X')THEN IIOO0IIlO0O0I01l00I1011II0011IIIII<=(OTHERS=>'X');III0IlIOll1Ill0I0I0OlIO10I1I1IIIII<='X';II0l10llII1lO0O1lOIlOOI10I0lIIIIII<='X';IIll0O11l1O1lOl111IIOlOIl0I0OIIIII<=(OTHERS=>(OTHERS=>'X'));IIO1IIOOO0OO1100OO11l0OOllIIIOIIII<=(OTHERS=>'X');
IOIOO101OO01Ol1101l1O01O1OOllIIIII<=(OTHERS=>'X');END IF;END PROCESS;OUT_SEL:PROCESS(IIOO0IIlO0O0I01l00I1011II0011IIIII)BEGIN IF C_SPEC=IIIOOIO01011011IOIIlllIIOO0l1IIIII THEN IF IO1IIIl1OO00II0ll110l0l0IIO0lIIIII(IIOO0IIlO0O0I01l00I1011II0011IIIII)THEN
 IIOlI0O00IO011lIIOl100O001lIOOIIII<=(OTHERS=>'X');ELSE IIOlI0O00IO011lIIOl100O001lIOOIIII<=IOIl1lI1IO111IO0OII101O1I0l0IOIIII(IOIlOIOl1lO1l001Ol10IO01OIlI1IIIII(IIOO0IIlO0O0I01l00I1011II0011IIIII));END IF;ELSE IIOlI0O00IO011lIIOl100O001lIOOIIII<=
IIOO0IIlO0O0I01l00I1011II0011IIIII;END IF;END PROCESS;GEN_RST_MIN_OUTPUT_GATE:PROCESS(CLK,RESET)VARIABLE IIlIIOOI1lOO0O0I1O1O10lI0OlIOOIIII:STD_LOGIC:='0';VARIABLE IOO0lOOOll1OI0OI0lI10IOOOII00IIIII:
STD_LOGIC:='0';VARIABLE II111O1llOOlI0lOOIIIl0OIlIlllIIIII:STD_LOGIC:='0';VARIABLE IIO11lIl110IO0lO00IOOl0Il11I1IIIII:INTEGER:=0;BEGIN IIlIIOOI1lOO0O0I1O1O10lI0OlIOOIIII:=II11I0011I0IIIl0100l1O01O01O0IIIII(RESET);IOO0lOOOll1OI0OI0lI10IOOOII00IIIII:=II11I0011I0IIIl0100l1O01O01O0IIIII(CLK);II111O1llOOlI0lOOIIIl0OIlIlllIIIII:=
II11I0011I0IIIl0100l1O01O01O0IIIII(II0I1O11OOll0l0I11O110OlI0lIOOIIII);IF(RESET'EVENT AND IIlIIOOI1lOO0O0I1O1O10lI0OlIOOIIII='1'AND II11I0011I0IIIl0100l1O01O01O0IIIII(RESET'LAST_VALUE)='0')THEN IIO11lIl110IO0lO00IOOl0Il11I1IIIII:=0;END IF;IF(CLK'EVENT AND IOO0lOOOll1OI0OI0lI10IOOOII00IIIII='1'AND
 II11I0011I0IIIl0100l1O01O01O0IIIII(CLK'LAST_VALUE)='0'AND II111O1llOOlI0lOOIIIl0OIlIlllIIIII='1'AND IIO11lIl110IO0lO00IOOl0Il11I1IIIII<=IOO1IIll11IlI110IOlllI1Il1IO1IIIII)THEN IIO11lIl110IO0lO00IOOl0Il11I1IIIII:=IIO11lIl110IO0lO00IOOl0Il11I1IIIII+1;END IF;IF(IIlIIOOI1lOO0O0I1O1O10lI0OlIOOIIII='0'AND
 IIO11lIl110IO0lO00IOOl0Il11I1IIIII<=IOO1IIll11IlI110IOlllI1Il1IO1IIIII AND IOO1IIll11IlI110IOlllI1Il1IO1IIIII/=0)THEN IOOI01II11O1I1IOII1II01O1001lIIIII<='0';ELSE IOOI01II11O1I1IOII1II01O1001lIIIII<='1';END IF;END PROCESS;
RST_MIN_OUTPUT_GATE:PROCESS(IIOlI0O00IO011lIIOl100O001lIOOIIII,III0IlIOll1Ill0I0I0OlIO10I1I1IIIII,IIl110lllO10l0llOI11l01I0I1OlIIIII,IOOI01II11O1I1IOII1II01O1001lIIIII)BEGIN IF(IOOI01II11O1I1IOII1II01O1001lIIIII='0')THEN IO111Il1I1O0lO1OlOI0l01I1O010IIIII<=(
OTHERS=>'X');III011IIIl1IO1l0O11000I0llI00IIIII<='X';II1O1ll0lOO0Ol1O0OO01I0OI0lIIOIIII<='X';ELSE IO111Il1I1O0lO1OlOI0l01I1O010IIIII<=IIOlI0O00IO011lIIOl100O001lIOOIIII;III011IIIl1IO1l0O11000I0llI00IIIII<=III0IlIOll1Ill0I0I0OlIO10I1I1IIIII;II1O1ll0lOO0Ol1O0OO01I0OI0lIIOIIII<=IIl110lllO10l0llOI11l01I0I1OlIIIII;END IF;
END PROCESS;IIl110lllO10l0llOI11l01I0I1OlIIIII<='X'WHEN C_HAS_RDY=0 ELSE II0l10llII1lO0O1lOIlOOI10I0lIIIIII;IOOll11IO1O1llOIl10010O1IIOOIIIIII<='X'WHEN C_HAS_RFD=0 ELSE IO1I1OlOI1OII110llI1lI0IIl0O0IIIII;IIII00I101O111lII1O000IO1lOOIIIIII<='X'WHEN C_HAS_RFFD=0 ELSE
 II110IO0lllI1lOI110IO00I1lOlIIIIII;DATA_OUT<=IO111Il1I1O0lO1OlOI0l01I1O010IIIII AFTER IIIIl1100lOI0I1OO1I00OlI0l10IIIIII;INFO<=III011IIIl1IO1l0O11000I0llI00IIIII AFTER IIIIl1100lOI0I1OO1I00OlI0l10IIIIII;RDY<=II1O1ll0lOO0Ol1O0OO01I0OI0lIIOIIII AFTER IIIIl1100lOI0I1OO1I00OlI0l10IIIIII;RFD
<=IOOll11IO1O1llOIl10010O1IIOOIIIIII AFTER IIIIl1100lOI0I1OO1I00OlI0l10IIIIII;RFFD<=IIII00I101O111lII1O000IO1lOOIIIIII AFTER IIIIl1100lOI0I1OO1I00OlI0l10IIIIII;END;
